import serial
from reader_functions import *
from packet_crunch_g2 import *
from assemble_packets import *
from packet_crunch import *

def GetGen2Inventory(antenna=0x00,power=0x12,Select=0x00,Session=0x00,Target=0x00,Qstart=4):
	'''This function assembles a command packet for a Gen 2 inventory and sends it to the serial port ser.
	The response, consisting of the payload stripped from all the response packets from the MPR, 
	is then parsed into an inventory summary and a list of tag IDs.'''
	
	cmd=Assemble_Gen2Inventory(antenna,power,Select,Session,Target,Qstart)
	cmd_bytes=String_to_bytes(cmd)
	#print 'new command to reader is', cmd_bytes
	write_to_serial_port(cmd)
	idlist=[]   #  initialize to empty list
	payload = Assemble_Response();    # this routine grabs the response frames from the MPR and 
					      # concatenates them, returning the whole list of tags from this inventory command
	if payload[0]=='ERROR':	# this is just an error packet
		return ('ERROR',payload[1])
	elif payload != ['NULL']:
		#  we got a valid payload, process it
		#print ('payload is ', payload)
		tagResponse=Split_Response_into_Tags_and_Summary(payload)[0]
		inventorySummary=Split_Response_into_Tags_and_Summary(payload)[1]
		if inventorySummary!='NULL':    	#  Split was happy so we can parse the response
			summaryTuple=Parse_Inventory_Summary(inventorySummary)
		if tagResponse!='NULL':    		# parse the response;  note that there is no access data in response
							# to an inventory
			EPClist=[]
			strippedResponse=tagResponse
			index=0      
			while (strippedResponse!='NULL'):  #strip EPCs from the front 'till there ain't no more
				strippedOutput=Strip_Leading_EPC_from_tagResponse(strippedResponse)
				strippedResponse=strippedOutput[1]
				nextEPC=strippedOutput[0]
				#print ('index is', index, 'and next EPC is', nextEPC)
				#print ('and stripped response is', strippedResponse)
				if (strippedResponse!='NULL'): 
					EPClist.append(nextEPC)
					index=index+1
		if (index!=summaryTuple[0]):
			print ('discrepancy between EPCs found',index,' and expected from summary:',summaryTuple[0])
		inventoryTuple=(EPClist,summaryTuple)
		return inventoryTuple
	else:
		return ('NULL','NULL')
	
	#  end case of valid packet received
	ser.flushInput()
	return idlist

#  ====================================================

def AssignTagListToStrings(taglist):
	'''This function takes a list of tags (each of which is a tuple of (id length, PC, EPC,reads))
	and splits it into four lists of ID length, PCword,  tagID, and reads respectively.  It cleans up
	the lists for display by converting the values to space-deliminted two-character bytes.'''
	
	if (taglist!='NULL'):
		#initialize the lists to store the results in
		IDlengthlist=[]
		PCwordlist=[]
		tagIDlist=[]
		nreadslist=[]
		
		for i in range(0,len(taglist),1):
			#print ('in AssignTagList...; taglist',i,' is:',taglist[i])
			IDlengthlist.append([taglist[i][0]])
			PCwordlist.append(taglist[i][1])
			tagIDlist.append(taglist[i][2])
			nreadslist.append([taglist[i][3]])
			
		#print ('in AssignTaglist... IDlengthlist is:',IDlengthlist)
		#print ('in AssignTaglist... PCwordlist is:',PCwordlist)
		#print ('in AssignTaglist... tagIDlist is:',tagIDlist)
		#print ('in AssignTaglist... nreadslist is:',nreadslist)
	
		IDlengthstring=Clean_up_list(IDlengthlist)
		PCwordstring=Clean_up_list(PCwordlist)
		tagIDstring=Clean_up_list(tagIDlist)
		nreadString=Format_number_list_for_printing(nreadslist)
		return (IDlengthstring,PCwordstring,tagIDstring,nreadString)
	else:
		return('NULL','NULL','NULL','NULL')
# end AssignTagListToStrings		
#  ====================================================

def Format_number_list_for_printing(nreadslist):
	'''This routine just takes a list of numbers, converts each to a string, and
	inserts a newline after each one, to produce a display string.'''
	
	displayString=' '
	for i in range(0,len(nreadslist),1):
		#print('in Format_number_list...  nreadslist[',i,'] is:', nreadslist[i])
		addString=str(nreadslist[i])[1:]   #   strip out leading bracket
		addString=addString[:len(addString)-1]   #  strip out trailing bracket
		displayString=displayString+addString+'\n'
	#displayString=displayString[1:]	#  strip out leading blank
	return displayString
	
# end Format_number_list_for_printing

#  ====================================================
		

