import serial
import CRCs   # this module has the CRC calculator functions
from packet_crunch import *
from assemble_packets import *     #  this module has the functions that assemble specific command packets
from packet_crunch_g2 import *    # this module has functions that parse Gen 2 packets
from time import *    # this built-in module has time functions for doing waits

class logstatus:
	'''This class contains two attributes, .TXstatus and .RXstatus, that control logging of serial packets.'''
	TXstatus=0	# default is off
	RXstatus=0	# default is off
	def setTXlog(self,statusbit):
		'''This method sets the transmit log status to statusbit, presumed 1 or 0.'''
		logstatus.TXstatus=statusbit
	def setRXlog(self,statusbit):
		'''This method sets the receive log to statusbit, presumed to be 1 or 0.'''
		logstatus.RXstatus=statusbit
	

def Set_serial_port(port='PCcard'):
	'''This function sets the parameters of the serial port,including the variant device named depending on 
	where the MPR is supposed to be.  It then opens the serial port.  Assumes .'''
	ser.baudrate = 57600
	ser.timeout=1000
	if port=='PCcard':
		ser.port = '/dev/tty.pccard-serial0'
		ser.open()
	if port=='USB':
		ser.port = '/dev/tty.KeySerial1'
		ser.open()
	print ser.portstr   # we  succeeded (or we crash); print the portstring to the standard output device to verify what we opened
	#end Set_serial_port
	
def write_to_serial_port(cmd):
	ser.write(cmd)
	if logtrack.TXstatus==1:
		cmd_bytes=String_to_bytes(cmd)
		print 'packet transmitted:',cmd_bytes

def Start_card_get_model():
	'''This function kicks the card until a good packet comes out, and then gets the MPR model for future use.'''
	print 'inside start card we find:', ser.portstr
	cmd=Assemble_GetReaderInfo()
	reply='NULL'
	tries=0
	while (reply=='NULL') and (tries<25):  #keep trying until we get a good packet
		write_to_serial_port(cmd)
		reply=Get_next_packet()
		ser.flushInput()
		tries=tries+1
	#  end while
	if tries==25:
		print 'no MPR card found!'
		return reply
	else:
		model='NULL'
		while model=='NULL':
			returnlist=GetReaderInfo()
			model=returnlist[1]
			print 'model is :', model
		return model
	#end Start_card_get_model
	
def Append_new_IDs(idout,newidlength,tagidlist):
	'''This routine checks to see if ids in idout are in tagidlist; if not, they are flagged as new and appended'''
	newidlist=()
	for y in range(0,newidlength,1):   # append any new id's to the list
		inflag=0
		for z in range(0,len(tagidlist),1):
			if idout[y]==tagidlist[z]:
				inflag=1
		# if it's new add to the list		
		if inflag==0:
			tagidlist=tagidlist+(idout[y],)
			newidlist=newidlist+	(idout[y],)   #  this list contains ONLY tags that weren't seen previously
			#print tagidlist
	# end loop to check for new ids
	return (newidlist,tagidlist)
	#end Append_new_IDs
	
def Clean_up_list(idlist):
	'''  This routine iterates through each element of an input list, presumed to be
	a list of lists of bytes, and removes the leading '0x';  then it replaces
	the leading zero if missing, inserts blanks between bytes, and inserts a newline at
	the end of each string of bytes.'''
	
	cleaned_up_list=' '      # accumulate the string of tag id's
	for tagid in idlist:    #  clean up the format of the id strings for printing
		idstring=' '
		for z in range(0,len(tagid),1):
			nextbyte=hex(tagid[z])[2:]    # strip out the '0x' on each hex string
			if len(nextbyte)==1:
				nextbyte='0'+nextbyte    # put the leading 0 back on if needed
			idstring=idstring + ' ' + nextbyte      
		cleaned_up_list=cleaned_up_list + idstring + '\n'		
	return cleaned_up_list
	# end Clean_up_list
	

def Get_next_packet():
	charswaiting=0
	starttime=time()     #  record the current time 
	maxwait=3   #  wait up to 3 seconds for a packet chunk
	timeout=0
	while ((charswaiting<3) and (timeout==0)):    #  so it can take a while to get a response!!  you have to extract length in bytes to know when to quit!
		charswaiting=ser.inWaiting()
		waittime=time()   # get current time
		if (waittime-starttime>maxwait):    # we ain't a gonna wait more than 3 seconds
			timeout=1
	if (timeout==0):     #  a normal exit from the loop;  we got the beginning of a good packet
		reply_chunk=ser.read(3)   # get the first 3 bytes of the reply; byte 3 is the length of the packet
		reply_length_list=String_to_bytes(reply_chunk)
		reply_length=reply_length_list[2]
		
		starttime=time()
		while ((charswaiting<(reply_length-2)) and (timeout==0)):
			charswaiting=ser.inWaiting()     # hold your horses until the data is in!
			waittime=time()  # get current time
			if(waittime-starttime>maxwait):   # we didn't get the rest of the packet
				timeout=1
		if (timeout==0):
			#print 'reply length is', reply_length
			reply=ser.read(reply_length-2)
			reply_list=String_to_bytes(reply)
			if logtrack.RXstatus==1:
				print "reply packet is",reply_list
			packetcheck=Validate_Received_Packet(reply_list, reply_length)
			if packetcheck:
				return reply
			else:
				print 'bad packet from MPR'
				return 'NULL'
		else:
			print 'packet not finished before time out'
			return 'NULL'
	else:
		print 'no packet received before time out'
		return 'NULL'
# end Get_next_packet

def testfnc():
	x=1
	return x

def GetReaderInfo():
	'''This function calls Assemble_GetReaderInfo to get the command packet, sends it to the serial port, and reads the response.
	It assumes that there is an open serial port attached to ser.  The input buffer gets flushed after we're done.'''
	#  get reader info
	cmd=Assemble_GetReaderInfo()
	write_to_serial_port(cmd)
	reply=Get_next_packet();
	if len(reply)>55:
		ser.flushInput()
		modelnumber=reply[1:9]
		serialnumber=reply[9:21]
		versionnumber=reply[21:29]
		manfrdate=reply[29:37]
		manufacturer=reply[37:53]
		firmware=Bytes_to_hex(String_to_bytes(reply[53:55]))
		print 'firmware =', firmware
		firmwarestring= firmware[0]+'.' + firmware[1]
		bootloader=Bytes_to_hex(String_to_bytes(reply[55:]))
		bootloaderstring=bootloader[0]+ '.' + bootloader[1]
		replystring=('model'+modelnumber+' SN'+serialnumber+' hardware ' + versionnumber + ' made on ' + manfrdate + ' by '
				+ manufacturer + ' FW version ' + firmwarestring + ' bootloader ' + bootloaderstring)
		#print  'reader info string ', replystring 
	else:
		replystring='no info packet'
		modelnumber='NULL'
	return (replystring,modelnumber)
# end GetReaderInfo


def Write_64bit_Class1EPC(antenna=0x00,power=0x0f,tagid=(0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00)):
	'''This function sends an 8-byte tagid two bytes at a time.  Tagid is a list of bytes.  If the first two bits of the first byte
	are 00 (which indicates a 96-bit tag) then we raise an exception and warn the user but don't do anything else. '''
	
	write_cmd=Assemble_Class1write(antenna,power,pointer=0x00,databyte1=tagid[0],databyte2=tagid[1])
	write_to_serial_port(write_cmd)
	next_packet=Get_next_packet()     # but don't do anything with it
	
	write_cmd=Assemble_Class1write(antenna,power,pointer=0x00,databyte1=tagid[2],databyte2=tagid[3])
	write_to_serial_port(write_cmd)
	next_packet=Get_next_packet()     # but don't do anything with it
	
	write_cmd=Assemble_Class1write(antenna,power,pointer=0x00,databyte1=tagid[4],databyte2=tagid[5])
	write_to_serial_port(write_cmd)
	next_packet=Get_next_packet()     # but don't do anything with it

	write_cmd=Assemble_Class1write(antenna,power,pointer=0x00,databyte1=tagid[6],databyte2=tagid[7])
	write_to_serial_port(write_cmd)
	next_packet=Get_next_packet()     # but don't do anything with it
	
#end Write_64bit_Class1EPC
	

def GetClass0Inventory(power=0x1b,antenna_index=0):
	'''This function calls Assemble_Class0Inventory with some default argument values -- could improve later
	to accept user values, and reads the response.  It assumes there is an open serial port attached to ser.  The input buffer
	gets flushed after we're done.  Note power is defaulted to 0x1b = 27 dBm, max power for an MPR5x or 6x.'''
	
	cmd=Assemble_Class0Inventory(antenna_index,power,2,0,0)
	cmd_bytes=String_to_bytes(cmd)
	#print 'new command to reader is', cmd_bytes
	write_to_serial_port(cmd)
	idlist=[]   #  initialize to empty list
	reply=Get_next_packet()
	#print 'reply to inventory is', reply
	if (len(reply))>1:    # we received a valid packet, proceed
		reply_bytes=String_to_bytes(reply)
		reply_in_hex=Bytes_to_hex(reply_bytes)
		#print 'reply in bytes is', reply_in_hex

		packet_status=reply_bytes[0]  # since we've stripped out the first 3 bytes in Get_next_packet, the fourth byte -- status -- is the first byte returned
		if packet_status==0xff:    # there is a packet error
			idlist=[[reply_bytes[1]]]    # this is the error
			#print("error in GetClass0Inventory; idlist is ", idlist)
		else:
			idlist=Strip_IDs_from_packet(reply_bytes)
			
		#print 'and the stripped id list is ', idlist
		morepackets=packet_status   
		
		#print 'morepackets is', morepackets
		while morepackets==1:
			reply=Get_next_packet()
			reply_bytes=String_to_bytes(reply)
			morepackets=reply_bytes[1]
			reply_in_hex=Bytes_to_hex(reply_bytes)
			idlist=idlist+Strip_IDs_from_packet(reply_bytes)
			#print 'next packet', reply_in_hex	
	#  end case of valid packet received
	ser.flushInput()
	return idlist
	
# end GetClass0Inventory

def GetClass1Inventory(power=0x1b,type=0,antenna_index=0):
	'''This function calls Assemble_Class1Inventory with some default argument values -- could improve later
	to accept user values, and reads the response.  Type=0 is standard inventory; type=1 is anti-collision.
	It assumes there is an open serial port attached to ser.  The input buffer
	gets flushed after we're done. Note power is defaulted to 0x1b = 27 dBm, max power for an MPR5x or 6x.  If the first 
	reply packet is an error (status 0xff) then idlist contains 1 byte with the error code.'''
	
	cmd=Assemble_Class1Inventory(antenna_index,power,0,0,type)
	cmd_bytes=String_to_bytes(cmd)
	#print 'new command to reader is', cmd_bytes
	write_to_serial_port(cmd)
	idlist=[]   #  initialize to empty list
	reply=Get_next_packet()
	#print 'reply to inventory is', reply
	if (len(reply))>1:    # we received a valid packet, proceed
		reply_bytes=String_to_bytes(reply)
		reply_in_hex=Bytes_to_hex(reply_bytes)
		#print 'reply in bytes is', reply_in_hex
		
		packet_status=reply_bytes[0]  # since we've stripped out the first 3 bytes in Get_next_packet, the fourth byte -- status -- is the first byte returned
		if packet_status==0xff:    # there is a packet error
			idlist=[[reply_bytes[1]]]
			#print("error in GetClass1Inventory; idlist is ", idlist)
		else:
			idlist=Strip_IDs_from_packet(reply_bytes)
			
		#print 'and the stripped id list is ', idlist
		morepackets=packet_status  
		#print 'morepackets is', morepackets
		while morepackets==1:
			reply=Get_next_packet()
			reply_bytes=String_to_bytes(reply)
			morepackets=reply_bytes[1]
			reply_in_hex=Bytes_to_hex(reply_bytes)
			idlist=idlist+Strip_IDs_from_packet(reply_bytes)
			#print 'next packet', reply_in_hex	
	#  end case of valid packet received
	ser.flushInput()
	return idlist
	
# end GetClass1Inventory

def GetClass1verify(antenna_index=0x00,power=0x0f):
	'''This function calls Assemble_Class1verify and reads the response.  It assumes there is an open serial port attached to ser.  The input buffer
	gets flushed after we're done.'''
	
	cmd=Assemble_Class1verify(antenna_index,power)
	cmd_bytes=String_to_bytes(cmd)
	#print 'new command to reader is', cmd_bytes
	write_to_serial_port(cmd)
	idlist=[]   #  initialize to empty list
	reply=Get_next_packet()
	#print 'reply to inventory is', reply
	if len(reply)>1:    # we received a valid packet, proceed
		reply_bytes=String_to_bytes(reply)
		reply_in_hex=Bytes_to_hex(reply_bytes)
		#print 'reply in bytes is', reply_in_hex
		
		idlist=Strip_longIDs_from_packet(reply_bytes)
		#print 'and the stripped id list is ', idlist
		morepackets=reply_bytes[0]   # since we've stripped out the first 3 bytes in Get_next_packet, the fourth byte -- status -- is the first byte returned
		
		#print 'morepackets is', morepackets
		while morepackets==1:
			reply=Get_next_packet()
			reply_bytes=String_to_bytes(reply)
			morepackets=reply_bytes[1]
			reply_in_hex=Bytes_to_hex(reply_bytes)
			idlist=idlist+Strip_longIDs_from_packet(reply_bytes)
			#print 'next packet', reply_in_hex	
	#  end case of valid packet received
	ser.flushInput()
	return idlist
	
# end GetClass1Verify



def Menuselections():
	print ' '
	print ' '
	print 'Selections:'
	print 'single class 0 inventory:	0'
	print 'single class 1 inventory:	1'
	print 'continuous class 0 inventory:	2'
	print 'continuous class 1 inventory:	3'
	print ' '
	print 'get reader info:			9'
	print 'quit program:			10'
# end Menuselections


def Print_single_Class0():
	''' This function runs a single class 0 inventory, then prints the resulting id list.'''
	# ask for an inventory
	idlist=GetClass0Inventory()
	totaltags=len(idlist)
	print 'total tags found are:', totaltags
	print 'and their ids are:'
	for x in range(0,totaltags,1):
		idout=idlist[x]
		#print 'idout is ', idout
		idlength=len(idout)
		idstring=' '
		for y in range(0,idlength,1):
			nextbyte=hex(idout[y])[2:]   # strip out the '0x' on each hex string
			if len(nextbyte)==1:
				nextbyte='0'+nextbyte   # add back in the leading 0 if needed
			idstring=idstring + ' ' + nextbyte    
		print idstring	
		
#   end Print_single_Class0


def Print_single_Class1():
	'''This function runs a single class 1 inventory, then prints the resulting id list.'''
	idlist=GetClass1Inventory()
	totaltags=len(idlist)
	print 'total tags found are:', totaltags
	print 'and their ids are:'
	for x in range(0,totaltags,1):
		idout=idlist[x]
		#print 'idout is ', idout
		idlength=len(idout)
		idstring=' '
		for y in range(0,idlength,1):
			nextbyte=hex(idout[y])[2:]
			if len(nextbyte)==1:
				nextbyte='0'+nextbyte
			idstring=idstring + ' ' + nextbyte    # strip out the '0x' on each hex string  
		print idstring	
#  end Print_single_Class1


def Print_multiple_Class0():
	'''This function runs a user-requested number of sets of 15 Class 0 inventories;
	after each 15 runs the cumulative tags read are printed out. '''
	ninventory=input('how many inventory cycles do you want?')
	for x in range(0,ninventory,1):      # for the number of inventories requested by the user
		tagidlist=()
		for y in range(0,15,1):	# run fifteen inventory cycles
			idout=GetClass0Inventory()
			#print idout
			newidlength=len(idout)
			for y in range(0,newidlength,1):   # append any new id's to the list
				inflag=0
				for z in range(0,len(tagidlist),1):
					if idout[y]==tagidlist[z]:
						inflag=1
				# if it's new add to the list		
				if inflag==0:
					tagidlist=tagidlist+(idout[y],)	
					#print tagidlist
			# end loop to check for new ids
		# end loop to run 15 inventories
		tagsfound=len(tagidlist)
		for tagid in tagidlist:    #  clean up the format of the id strings for printing
			idstring=' '
			for z in range(0,len(tagid),1):
				nextbyte=hex(tagid[z])[2:]    # strip out the '0x' on each hex string
				if len(nextbyte)==1:
					nextbyte='0'+nextbyte    # put the leading 0 back on if needed
				idstring=idstring + ' ' + nextbyte      
			print idstring	
		print ' '
		x=x+1   # increment the inventory set number
	# end of the loop over the number of inventory sets requested by the user
#  end Print_multiple_Class0




def Print_multiple_Class1():
	'''This function runs a user-requested number of sets of 15 Class 1 inventories;
	after each 15 runs the cumulative tags read are printed out. '''
	ninventory=input('how many inventory cycles do you want?')
	for x in range(0,ninventory,1):      # for the number of inventories requested by the user
		tagidlist=()
		for y in range(0,15,1):	# run fifteen inventory cycles
			idout=GetClass1Inventory()
			#print idout
			newidlength=len(idout)
			for y in range(0,newidlength,1):   # append any new id's to the list
				inflag=0
				for z in range(0,len(tagidlist),1):
					if idout[y]==tagidlist[z]:
						inflag=1
				# if it's new add to the list		
				if inflag==0:
					tagidlist=tagidlist+(idout[y],)	
					#print tagidlist
			# end loop to check for new ids
		# end loop to run 15 inventories
		tagsfound=len(tagidlist)
		for tagid in tagidlist:    #  clean up the format of the id strings for printing
			idstring=' '
			for z in range(0,len(tagid),1):
				nextbyte=hex(tagid[z])[2:]    # strip out the '0x' on each hex string
				if len(nextbyte)==1:
					nextbyte='0'+nextbyte    # put the leading 0 back on if needed
				idstring=idstring + ' ' + nextbyte      
			print idstring	
		print ' '
		x=x+1   # increment the inventory set number
	# end of the loop over the number of inventory sets requested by the user
#  end Print_multiple_Class1



#  ====================================================


#create a serial port instance which will get configured in Set_serial_port
ser=serial.Serial()
model='NULL'

#create an instance of the logstatus class

logtrack = logstatus()
#Set_serial_port('USB')
#print 'test is:', ser.portstr
#model=Start_card_get_model()
#print 'model is:', model
#ser.close()

	
	