import serial
from packet_crunch import *
import reader_functions
import CRCs      #  this module has the CRC calculator functions

#  G2 packet manipulation and parsing functions

def Append_String_to_Payload(inputstring,payload):
	'''This function converts a string to bytes and appends each byte to payload, which is presumed to be a list of bytes.
	Other than assuming the first argument is a string and the second a byte list no assumptions are made about them.'''
	
	stringlength=len(inputstring)
	#   if the input string is non-empty iterate over the elements of the string
	if len>0:
		inputbytes=String_to_bytes(inputstring)	# this returns a tuple with a byte for each character
		for y in range(0,stringlength,1):
			payload=payload+[inputbytes[y]]
	return payload
	#  if length = 0 (null input string) don't do anything to payload
#end Append_String_to_Payload
#
#
#  
#
#
#
def Assemble_Response():
	'''This function calls Get_next_packet and concatenates the payload of that packet to 
	previous ones, until the packet status is 0x00.  It then returns the concatenated payload.
	If at any time the process dies due to a timeout or bad packet it returns 'NULL' instead.  
	We assume that Get_next_packet provides a string the first byte of which is status (used and discarded), and the last
	two bytes are the serial packet CRC (not needed here), so only the concatenated payload is returned. '''
	
	
	response=[]    #  initialize response to an empty list
	done='false'	#  this gets set to true when the packet status of the received packet is 0x00
	while (done=='false'):
		packetstring=reader_functions.Get_next_packet();    #packetstring should be either NULL or an ASCII string corresponding to the packet with SOF and NODE removed
		if (packetstring=='NULL'):    #  Get_next_packet timed out or got a bad packet
			done='true'
			response=['NULL']
		elif (packetstring[0]==chr(0xff)):	#  this is an error packet;  just return the error code
			print ('in Assemble_response, packet from GNP is: ',packetstring)
			done='true'
			error_code=String_to_bytes(packetstring)
			response=['ERROR',error_code[1]]
			print ('in Assemble_response, error response is: ',response)
		else:
			nbytes=len(packetstring)
			appendstring=packetstring[1:nbytes-2]	#  slice off the status byte (beginning) and serial packet CRC (last 2 bytes)
			response=Append_String_to_Payload(appendstring,response)    # append the payload of this packet
			#print ('from inside Assemble_Response, response is:',response)
			if packetstring[0]==chr(0):    #  this is the last packet
				done='true'
		# end while
	return response
	print ('response is', response)
#end Assemble_Response
#
#
#
#
#
#
#
#
def Split_Response_into_Tags_and_Summary(response):
	'''This function simply strips the last 6 words (12 bytes) of response (a list of bytes) and assigns them to
	the list inventorySummary, and assigns what's left to tagResponse, both are which are also byte lists.  It then
	returns the tuple splitResponse, the first element of which is tagResponse and the second element inventorySummary.'''
	#
	responseLength=len(response)
	if responseLength>11:
		inventorySummary=response[responseLength-12:]	#  the last 6 words of response
		tagResponse=response[:responseLength-12]     		# what's left;  remember slicing does not include the last index value
		splitResponse=(tagResponse,inventorySummary)
		return splitResponse
	else:
		print('invalid response -- too short')
		splitResponse=('NULL','NULL')
		return splitResponse
		
# end Split_Response_into_Tags_and_Summary
#
#
#
#
#
#
def Parse_Inventory_Summary(summary):
	'''This function receives a byte list presumed to be 12 bytes long.  It splits the list into 6 words
	and then converts them to numerical values which are returned in a tuple.  If the input list is the
	wrong length we just return a tuple filled with NULL.'''
	
	summLength=len(summary)
	#print ('from Parse_Inventory_Summary, summary is:', summary)
	if summLength!=12:
		print ('summary must be 12 bytes long')
		print ('bad summary:', summary)
		return ('NULL','NULL','NULL','NULL','NULL','NULL')
	else:
		nTags=256*summary[0]+summary[1]
		nSlots=256*summary[2]+summary[3]
		nEPC_CRCerrors=256*summary[4]+summary[5]
		nserialCRCerrors=256*summary[6]+summary[7]
		nCollisions=256*summary[8]+summary[9]
		nRounds=256*summary[10]+summary[11]
		summaryTuple=(nTags,nSlots,nEPC_CRCerrors,nserialCRCerrors,nCollisions,nRounds)
		#print ('summaryTuple is:', summaryTuple)
		return summaryTuple
#end Parse_Inventory_Summary(summary)
#
#
#
#
#
#
#
#
def Strip_Leading_EPC_from_tagResponse(tagResponse):
	'''This function receives a tag response, presumed to be a list of bytes starting with an EPC response.
	It reads the tag ID length and then strips out the bytes corresponding to the ID length, the protocol
	control bits, and the tag ID itself.  These are placed in a tuple.  This tuple and the remaining bytes
	are returned in a larger tuple.   If the supplied array isn't long enough we return a tuple of NULL.'''
	
	badInput='false'
	respLength=len(tagResponse)
	#print ('inside Strip_Leading_EPC...,response length is:', respLength)
	if respLength<11:   # not big enough to contain an EPC response to say nothing of an access response, assuming minimum tagID of 8 bytes
		badInput='true'
	else:
		tagIDlength=tagResponse[0]	# extract the first byte to get the ID length
		if (tagIDlength+3>respLength):	#  the response is not actually long enough to be a valid response
			badInput='true'
		else:
			PCword=tagResponse[1:3]     # extract the protocol control word
			tagID=tagResponse[3:2*tagIDlength+3]   #extract the tag ID
			#print ('from inside Strip_Leading_EPC..., tagIDlength is:', tagIDlength,' and we stripped:', 2*tagIDlength+3,' bytes')
		#end of case tagResponse long enough to contain the cited tag ID
	#  end of case of tagResponse long enough to bother to parse
	if (badInput=='true'):
		return ('NULL','NULL')
	else:
		leadingEPC=(tagIDlength,PCword,tagID)    # the EPC as a tuple of (number, byte list, byte list)
		strippedResponse=tagResponse[2*tagIDlength+3:]
		returnTuple=(leadingEPC,strippedResponse)
		return returnTuple
	#end case of good input list
	
#end Strip_Leading_EPC...
#
#
#
#
#
#
def Strip_Leading_accessResponse_from_tagResponse(tagResponse):
	'''This function receives a tag response, presumed to be a list of bytes starting with an access response.
	It reads the access status and access data length, and then uses access data length to read an access data tuple.
	These three objects are then placed in a tuple.  This tuple and the remaining bytes
	are returned in a larger tuple, returnTuple.   If the supplied array isn't long enough we return a tuple of NULL.  
	Note that when no data is present (e.g. if accessDataLength=0, or when we use up all the data in tagResponse)
	we return an empty list in the appropriate slots of returnTuple, but do not throw an error.'''
	
	badInput='false'
	respLength=len(tagResponse)
	if respLength<3:   # not big enough to contain a valid access response 
		badInput='true'
	else:
		accessStatus=tagResponse[0]	# extract the first byte to get the access status
		accessDataLength=256*tagResponse[1]+tagResponse[2]
		if (accessDataLength+3>respLength):	#  the response is not actually long enough to be a valid response
			badInput='true'
		else:
			accessData=tagResponse[3:accessDataLength+3]     # extract the access data
		#end of case tagResponse long enough to contain the cited data
	#  end of case of tagResponse long enough to bother to parse
	if (badInput=='true'):
		return ('NULL','NULL')
	else:
		leadingAccessData=(accessStatus,accessDataLength,accessData)    # the data as a tuple (number, number, byte list)
		strippedResponse=tagResponse[accessDataLength+3:]
		returnTuple=(leadingAccessData,strippedResponse)
		return returnTuple
	#end case of good input list
#end Strip_Leading_accessResponse_from_tagResponse
#
#
#
#
#
#ser=serial.Serial()
#model='NULL'
#model=Start_card_get_model()

	