import serial
import CRCs      #  this module has the CRC calculator functions

def Strip_IDs_from_packet(inputlist):
	''' This function gets a packet, which it presumes to start with the Status byte.  It verifies that the status is 01; 
	if the status is 00 or an error, the function returns an empty list.  Otherwise it reads the next byte to get the number of tags, and then
	builds a return list of id's (nested) by extracting the bytes of the tag ID based on the first byte's first two bits (64 or 96).'''
	if inputlist[0]==1:
		# this packet contains ID's and not errors or summary
		# first get the number of ID's found
		ntagsfound=inputlist[1]
		#print 'number of tags found is ', ntagsfound
		pointer=2    # this keeps track of where we are in the input list
		idlist=[]      # initialize the list of id's to empty
		for x in range(0,ntagsfound,1):   # now extract the id
			if inputlist[pointer]<63:    #  the first two bits are 0 =>  this is a 96-bit tag
				idlist=idlist+[inputlist[pointer:pointer+12]]
				pointer=pointer+12
			else:    # the first two bits are not 0  =>  this is a 64-bit tag
				idlist=idlist+[inputlist[pointer:pointer+8]]
				pointer=pointer+8
		return idlist
	else:
		return []   # an empty list
#end Strip_IDs_from_packet

def Strip_longIDs_from_packet(inputlist):
	''' This function gets a packet, which it presumes to start with the Status byte.  It verifies that the status is 01; 
	if the status is 00 or an error, the function returns an empty list.  Otherwise it reads the next byte to get the number of tags, and then
	builds a return list of id's (nested) by extracting the bytes of the tag ID based on the first byte's first two bits (64 or 96).  The ID list here
	includes the CRC at the front and the kill passcode at the back; thus it goes with the VERIFY command.'''
	if inputlist[0]==1:
		packetlength=len(inputlist)
		# this packet contains ID's and not errors or summary
		# first get the number of ID's found
		#print 'input list =', inputlist
		ntagsfound=inputlist[1]
		#print 'number of tags found is ', ntagsfound
		pointer=2    # this keeps track of where we are in the input list
		idlist=[]      # initialize the list of id's to empty
		for x in range(0,ntagsfound,1):   # now extract the id
			CRClist=inputlist[pointer:pointer+2]  #  the first two bytes (see API p. 23) are the CRC
			pointer=pointer+2
			if inputlist[pointer]<63:    #  the first two bits of the ID are 0 =>  this is a 96-bit tag
				if (pointer+12)<packetlength:
					longID=inputlist[pointer:pointer+12]
					pointer=pointer+12
				else:
					longID=inputlist[pointer:]
					pointer=packetlength
			else:    # the first two bits are not 0  =>  this is a 64-bit tag
				if (pointer+8)<packetlength:
					longID=inputlist[pointer:pointer+8]
					pointer=pointer+8
				else:
					longID=inputlist[pointer:]
					pointer=packetlength
			if pointer<packetlength:
				Killcode=(inputlist[pointer],)   #  this is the kill passcode
				pointer=pointer+1
			else:
				Killcode=('NULL')
			taginfo=(longID,CRClist,Killcode)
			idlist=idlist+[taginfo]
		return idlist
	else:
		return []   # an empty list
#end Strip_IDs_from_packet

def Validate_Received_Packet(Inputlist, Recpacketlength):
	'''This function checks the CRC of the received packet against the calculated value from the data, and returns
	TRUE if the packet is okay, FALSE if it isn't.  It prepends the first two bytes of the packet, which were 
	presumed to be stripped off during the serial read process:  node address (always 0x00) and the passed-in 
	Recpacketlength, which is the reported length in bytes of the packet minus SOF.'''
	#
	#  prepend packet length byte and node
	Inputlist=(Recpacketlength,)+Inputlist
	#print 'first prepend gives:', Inputlist
	Inputlist=(0x00,)+Inputlist
	#print 'second prepend gives:',Inputlist
	# the packet is now the received packet except for SOF
	#
	# find CRC reported in received packet
	Highrecbyte=Inputlist[Recpacketlength-2]   #second to the last byte
	Lowrecbyte=Inputlist[Recpacketlength-1]   # last byte
	CRCrec=Highrecbyte*256+Lowrecbyte
	#print 'received CRC is', hex(CRCrec)
	#
	# calculate the CRC on the packet
	CRCinputlist=Inputlist[0:Recpacketlength-2]  # strip off the received CRC
	CRCinputlength=len(CRCinputlist)
	CRCcalc=CRCs.MPR_CRC(CRCinputlist,CRCinputlength,0xffff)
	#print 'calculated CRC is', hex(CRCcalc)
	if CRCrec==CRCcalc:
		return 1  # true, we're ok
	else:
		return 0   # false, bad packet
# end Validate_Received_Packet

def String_to_bytes(input_string):
	'''This function converts an input string into a list of bytes'''
	x=len(input_string)
	packet_bytes=()   # empty tuple
	for y in range(0,x,1):
		packet_bytes=packet_bytes+(ord(input_string[y]),)
	return packet_bytes
#end of String_to_bytes

def Bytes_to_hex(inputlist):
	'''This function converts a list of numbers to a list of strings showing them in hex format'''
	x=len(inputlist)
	outputlist=[]
	for y in range(0,x,1):
		outputlist=outputlist+[hex(inputlist[y])]
	return outputlist
# end Bytes_to_hex