import CRCs   # this module has the CRC calculator functions
from packet_crunch import *    #  to get the packet processing functions


def Assemble_GetReaderInfo():
	''' This function assembles a command packet for the command GetReaderInfo'''
	#
	cmd_packet=chr(0x01)  # the first character of the packet is the start-of-frame
	cmd_packet=cmd_packet+chr(0x00)   # next character is the node, always zero
	cmd_packet=cmd_packet+chr(0x05)  # next character is the packet length for this (invariant) packet
	cmd_packet=cmd_packet+chr(0x01)   # the next character is the command
	cmd_packet=cmd_packet+chr(0xdc)    # since this command is invariant no need to calculate the CRC, just put it in
	cmd_packet=cmd_packet+chr(0xb7)
	return cmd_packet 

#end function Assemble_GetReaderInfo

def Assemble_Class0Inventory(antenna=0x00,power=0x0f,singulation=0x02,filter_bits=0x00,filter=0x00):
	'''This function assembles a request to do a class 0 inventory.  Antenna is defaulted to 0 (a), power to 15 dBm, singulation to ID2
	(the EPC), and filter bits and filter are defaulted to 0 for no filter'''
	#
	#
	cmd_packet=chr(0x01)  # the first character of the packet is the start-of-frame
	cmd_packet=cmd_packet+chr(0x00)   # next character is the node, always zero
	cmd_packet=cmd_packet+chr(0x09)  # next character is the packet length for this (invariant) packet
	cmd_packet=cmd_packet+chr(0x11)   # the next character is the command
	cmd_packet=cmd_packet+chr(antenna) #  select the antenna
	cmd_packet=cmd_packet+chr(power)   # set the power level in dBm  (should add a check for valid range later!!)  
	cmd_packet=cmd_packet+chr(singulation)   # choose which number to use for singulation
	cmd_packet=cmd_packet+chr(filter_bits)  #  number of bits to filter
	#    cmd_packet=cmd_packet+chr(filter)    filtering capability not yet supported!!!
	cmd_byte_list=String_to_bytes(cmd_packet)   
	#    print 'byte list returned from command assembly', cmd_byte_list  
	cmd_byte_list=cmd_byte_list[1:]    #strip off the first -SOF- byte 
	#    print 'byte list after SOF removal is', cmd_byte_list
	listlength=len(cmd_byte_list)
	CRCvalue=CRCs.MPR_CRC(cmd_byte_list,listlength,0xffff)
	#    print 'calculated CRC is', CRCvalue
	CRClowbyte=CRCvalue&0x00ff
	CRChighbyte=CRCvalue>>8
	#    print 'low byte is', CRClowbyte, 'and high byte is', CRChighbyte
	cmd_packet=cmd_packet+chr(CRChighbyte)    # CRC for the default values
	cmd_packet=cmd_packet+chr(CRClowbyte)
	return cmd_packet 
	
#end function Assemble_Class0Inventory	

def Assemble_Class1Inventory(antenna=0x00,power=0x0f,filter_bits=0x00,filter=0x00,type=0):
	'''This function assembles a request to do a class 1 inventory.  Antenna is defaulted to 0 (a), power to 15 dBm,
	 and filter bits and filter are defaulted to 0 for no filter.  Type=0 is the old inventory command with no 
	anti-collision; type=1 is the newer command with anti-collision.  '''
	#
	#
	cmd_packet=chr(0x01)  # the first character of the packet is the start-of-frame
	cmd_packet=cmd_packet+chr(0x00)   # next character is the node, always zero
	cmd_packet=cmd_packet+chr(0x08)  # next character is the packet length for this (invariant) packet
	if (type==1):
		cmd_packet=cmd_packet+chr(0x27)  # the next character is the command, here anti-collision inventory
	else:
		cmd_packet=cmd_packet+chr(0x21)   # or here (for all cases including wrong types) conventional inventory
	#print 'type is ', type
	cmd_packet=cmd_packet+chr(antenna) #  select the antenna
	cmd_packet=cmd_packet+chr(power)   # set the power level in dBm  (should add a check for valid range later!!)  
	cmd_packet=cmd_packet+chr(filter_bits)  #  number of bits to filter
	#   cmd_packet=cmd_packet+chr(filter)   #  filtering capability not yet supported!!!  
	cmd_byte_list=String_to_bytes(cmd_packet)   
	#   print 'byte list returned from command assembly', cmd_byte_list  
	cmd_byte_list=cmd_byte_list[1:]    #strip off the first -SOF- byte 
	#    print 'byte list after SOF removal is', cmd_byte_list
	listlength=len(cmd_byte_list)
	CRCvalue=CRCs.MPR_CRC(cmd_byte_list,listlength,0xffff)
	#     print 'calculated CRC is', CRCvalue
	CRClowbyte=CRCvalue&0x00ff
	CRChighbyte=CRCvalue>>8
	#    print 'low byte is', CRClowbyte, 'and high byte is', CRChighbyte
	cmd_packet=cmd_packet+chr(CRChighbyte)    # CRC for the default values
	cmd_packet=cmd_packet+chr(CRClowbyte)
	return cmd_packet 
	
#end function Assemble_Class1Inventory	



def Assemble_Class1write(antenna=0x00,power=0x0f,pointer=0x00,databyte1=0x00,databyte2=0x00):
	'''This function assembles a request to write 2 bytes to a class 1 tag starting at the location specified by pointer.
	Note there is no filter so any tag in range is written.'''
	#
	#
	cmd_packet=chr(0x01)  # the first character of the packet is the start-of-frame
	cmd_packet=cmd_packet+chr(0x00)   # next character is the node, always zero
	cmd_packet=cmd_packet+chr(0x0a)  # next character is the packet length for this (invariant) packet
	cmd_packet=cmd_packet+chr(0x23)   # the next character is the command
	cmd_packet=cmd_packet+chr(antenna) #  select the antenna
	cmd_packet=cmd_packet+chr(power)   # set the power level in dBm  (should add a check for valid range later!!)  
	cmd_packet=cmd_packet+chr(pointer)  #  where to start; must be in (0,16,32,48,64,80,96)
	cmd_packet=cmd_packet+chr(databyte1)    #  note data should be MSB-first
	cmd_packet=cmd_packet+chr(databyte2)     #  and the second byte
	cmd_byte_list=String_to_bytes(cmd_packet)   
	print 'byte list returned from command assembly', cmd_byte_list  
	cmd_byte_list=cmd_byte_list[1:]    #strip off the first -SOF- byte 
	print 'byte list after SOF removal is', cmd_byte_list
	listlength=len(cmd_byte_list)
	CRCvalue=CRCs.MPR_CRC(cmd_byte_list,listlength,0xffff)
	print 'calculated CRC is', CRCvalue
	CRClowbyte=CRCvalue&0x00ff
	CRChighbyte=CRCvalue>>8
	print 'low byte is', CRClowbyte, 'and high byte is', CRChighbyte
	cmd_packet=cmd_packet+chr(CRChighbyte)    # CRC for the default values
	cmd_packet=cmd_packet+chr(CRClowbyte)
	return cmd_packet 
	
#end function Assemble_Class1write


def Assemble_Class1erase(antenna=0x00,power=0x0f):
	'''This function assembles a request to erase a class 1 tag.
	Note there is no filter so any tag in range is erased!'''
	#
	#
	cmd_packet=chr(0x01)  # the first character of the packet is the start-of-frame
	cmd_packet=cmd_packet+chr(0x00)   # next character is the node, always zero
	cmd_packet=cmd_packet+chr(0x07)  # next character is the packet length for this (invariant) packet
	cmd_packet=cmd_packet+chr(0x25)   # the next character is the command
	cmd_packet=cmd_packet+chr(antenna) #  select the antenna
	cmd_packet=cmd_packet+chr(power)   # set the power level in dBm  (should add a check for valid range later!!)  
	cmd_byte_list=String_to_bytes(cmd_packet)   
	print 'byte list returned from command assembly', cmd_byte_list  
	cmd_byte_list=cmd_byte_list[1:]    #strip off the first -SOF- byte 
	print 'byte list after SOF removal is', cmd_byte_list
	listlength=len(cmd_byte_list)
	CRCvalue=CRCs.MPR_CRC(cmd_byte_list,listlength,0xffff)
	print 'calculated CRC is', CRCvalue
	CRClowbyte=CRCvalue&0x00ff
	CRChighbyte=CRCvalue>>8
	print 'low byte is', CRClowbyte, 'and high byte is', CRChighbyte
	cmd_packet=cmd_packet+chr(CRChighbyte)    # CRC for the default values
	cmd_packet=cmd_packet+chr(CRClowbyte)
	return cmd_packet 
	
#end function Assemble_Class1erase

def Assemble_Class1verify(antenna=0x00,power=0x0f):
	'''This function assembles a request to verify a class 1 tag.'''
	#
	#
	cmd_packet=chr(0x01)  # the first character of the packet is the start-of-frame
	cmd_packet=cmd_packet+chr(0x00)   # next character is the node, always zero
	cmd_packet=cmd_packet+chr(0x07)  # next character is the packet length for this (invariant) packet
	cmd_packet=cmd_packet+chr(0x24)   # the next character is the command
	cmd_packet=cmd_packet+chr(antenna) #  select the antenna
	cmd_packet=cmd_packet+chr(power)   # set the power level in dBm  (should add a check for valid range later!!)  
	cmd_byte_list=String_to_bytes(cmd_packet)   
	#print 'byte list returned from command assembly', cmd_byte_list  
	cmd_byte_list=cmd_byte_list[1:]    #strip off the first -SOF- byte 
	#print 'byte list after SOF removal is', cmd_byte_list
	listlength=len(cmd_byte_list)
	CRCvalue=CRCs.MPR_CRC(cmd_byte_list,listlength,0xffff)
	#print 'calculated CRC is', CRCvalue
	CRClowbyte=CRCvalue&0x00ff
	CRChighbyte=CRCvalue>>8
	#print 'low byte is', CRClowbyte, 'and high byte is', CRChighbyte
	cmd_packet=cmd_packet+chr(CRChighbyte)    # CRC for the default values
	cmd_packet=cmd_packet+chr(CRClowbyte)
	return cmd_packet 
	
#end function Assemble_Class1verify

def Assemble_Gen2Inventory(antenna=0x00,power=0x12,Select=0x00,Session=0x00,Target=0x00,Qstart=4):
	'''This function  assembles a Gen 2 inventory packet.  Power defaults to 18 dBm, Select defaults to 0 (all tags
	are inventoried), Session defaults to 0 (session 0), target defaults to 0 (inventory flag =A), and starting Q
	defaults to 4, appropriate for a few tens of tags in the field.'''
	#
	#
	cmd_packet=chr(0x01)  # the first character of the packet is the start-of-frame
	cmd_packet=cmd_packet+chr(0x00)   	# next character is the node, always zero
	cmd_packet=cmd_packet+chr(0x0C)  	# next character is the packet length for this (invariant) packet
	cmd_packet=cmd_packet+chr(0x60)   	# the next character is the command
	cmd_packet=cmd_packet+chr(0x01)    	# next character is the subcommand
	cmd_packet=cmd_packet+chr(antenna) 	#  select the antenna
	cmd_packet=cmd_packet+chr(power)   	# set the power level in dBm  
	cmd_packet=cmd_packet+chr(Select)    	# the SL flag can be ignored, or we can inventory only tags with SL set or reset
	cmd_packet=cmd_packet+chr(Session)   	#  Gen 2 supports up to 4 simultaneous sessions
	cmd_packet=cmd_packet+chr(Target)   	#  a tag that is inventories flips its flag between 2 states, A and B; here we decide which population to read
	cmd_packet=cmd_packet+chr(Qstart)	# the number of time slots for replying to the inventory is 2^Q, so Q is small when only a few tags
							# are expected and large when many tags are likely
	cmd_byte_list=String_to_bytes(cmd_packet)   	
							
	#print 'byte list returned from command assembly', cmd_byte_list  
	cmd_byte_list=cmd_byte_list[1:]    #strip off the first -SOF- byte 
	#print 'byte list after SOF removal is', cmd_byte_list
	listlength=len(cmd_byte_list)
	CRCvalue=CRCs.MPR_CRC(cmd_byte_list,listlength,0xffff)
	#print 'calculated CRC is', CRCvalue
	CRClowbyte=CRCvalue&0x00ff
	CRChighbyte=CRCvalue>>8
	#print 'low byte is', CRClowbyte, 'and high byte is', CRChighbyte
	cmd_packet=cmd_packet+chr(CRChighbyte)    # CRC for the default values
	cmd_packet=cmd_packet+chr(CRClowbyte)
	return cmd_packet 
	
#end function Assemble_Gen2Inventory



