from Tkinter import *                  # these are the graphical user interface functions and widgets
from reader_functions  import * # this module has the functions that actually talk to the reader
import serial
from assemble_packets import * # this module has the functions that assemble specific command packets
				      #  note that pyserial has to be present for them to work!
from reader_functions_g2 import *
				       #  this is the set of gen2 reader functions
from CRCs import *		       # bring the CRC calculator in for the class1 VERIFY routine
from time import *	                   # these are system time functions



class MPRGUI:
	''' This class creates the graphical user interface.  The root window gets a frame, that is further subdivided into a top and bottom frame.
	The top frame contains the user interface buttons.  The bottom frame is further subdivided into a section with the MPR reader info window,
	and a section with the text fields for listing the tags read.  The button handlers depend on the update function to capture the STOP button inside 
	their repeating loop without having to leave the TK mainloop.'''
	#
	def __init__(self,parent):
		self.myparent=parent

		self.mycontainer1=Frame(parent,bg='#aca')	# this is the frame that contains the whole GUI window and all widgets
		self.mycontainer1.pack()
		
		self.topframe=Frame(self.mycontainer1,bg='#fff',relief=SUNKEN, borderwidth=5)    #  this frame contains the user interface buttons
		self.topframe.pack(side=TOP)
		
		self.bottomframe=Frame(self.mycontainer1,bg='#bbb', relief=SUNKEN, borderwidth=5)   # this frame contains the reader info window and the tag windows
		self.bottomframe.pack(side=BOTTOM)
				
		self.midframe=Frame(self.bottomframe)      #  this sub-frame contains the reader info window
		self.midframe.pack(side=TOP)
		
		# ----------------------------
		self.serialframe=Frame(self.topframe,bg='#fff')   # this temporary frame contains the serial port setting buttons
		self.serialframe.pack(side=LEFT)
		
		self.PCcardbutton=Button(self.serialframe,text='PC CARD',bg='#aaa')
		self.PCcardbutton.pack(side=TOP)
		self.PCcardbutton.bind('<Button-1>',self.PCcardport)

		self.USBbutton=Button(self.serialframe,text='USB SERIAL',bg='#aaa')
		self.USBbutton.pack(side=TOP)
		self.USBbutton.bind('<Button-1>',self.USBport)	
		
		# - - - - - - - - - - - - - - - - - - - - - 
		
		self.class0frame=Frame(self.topframe,bg='#fff')      #  this frame contains the Class 0 inventory and copy buttons
		self.class0frame.pack(side=LEFT,fill=Y)
		
		self.cl0_label=Label(self.class0frame, width=8,text=' Class 0')   #  label the frame
		self.cl0_label.pack(side=TOP)		
		
		self.class0button=Button(self.class0frame,width=12,text='INVENTORY',bg='#aaa')
		self.class0button.pack(side=TOP)
		self.class0button.bind('<Button-1>',self.class0inventory)

		self.class0tagstrengthbutton=Button(self.class0frame,width=12,text='TAG STRENGTH',bg='#aaa')
		self.class0tagstrengthbutton.pack(side=TOP)
		self.class0tagstrengthbutton.bind('<Button-1>',self.class0tagstrength)			
		
		self.copyclass0button=Button(self.class0frame,width=12,text='COPY CLASS 0',bg='#aaa')   
		self.copyclass0button.pack(side=BOTTOM)
		self.copyclass0button.bind('<Button-1>',self.copyclass0)
		
		# -----------------------------
		
		self.class1frame=Frame(self.topframe,bg='#fff')    # this frame contains the Class 1 inventory, verify, and copy buttons
		self.class1frame.pack(side=LEFT,fill=Y)
		
		self.cl1_label=Label(self.class1frame, width=8,text=' Class 1')   #  label the frame
		self.cl1_label.pack(side=TOP)		
		
		self.class1button=Button(self.class1frame,width=12,text='INVENTORY',bg='#aaa')
		self.class1button.pack(side=TOP)
		self.class1button.bind('<Button-1>',self.class1inventory)
		
		self.class1verifybutton=Button(self.class1frame,width=12,text='VERIFY',bg='#aaa')
		self.class1verifybutton.pack(side=TOP)
		self.class1verifybutton.bind('<Button-1>',self.class1verify)
		
		self.class1tagstrengthbutton=Button(self.class1frame,width=12,text='TAG STRENGTH',bg='#aaa')
		self.class1tagstrengthbutton.pack(side=TOP)
		self.class1tagstrengthbutton.bind('<Button-1>',self.class1tagstrength)		
		
		self.copyclass1button=Button(self.class1frame,width=12,text='COPY CLASS 1',bg='#aaa')   
		self.copyclass1button.pack(side=BOTTOM)
		self.copyclass1button.bind('<Button-1>',self.copyclass1)
		
		# ----------------------------
		
		self.chkbuttonframe=Frame(self.topframe,bg='#fff')      #  this frame contains the accumulate and class 1 inventory type options 
		self.chkbuttonframe.pack(side=LEFT,fill=Y)
		
		self.gen2button=Button(self.chkbuttonframe,text='Gen II',bg='#aaa')
		self.gen2button.pack(side=TOP)
		self.gen2button.bind('<Button-1>',self.gen2)
		
		self.getreaderbutton=Button(self.chkbuttonframe,text='Get info',bg='#aaa')
		self.getreaderbutton.pack(side=TOP)
		self.getreaderbutton.bind('<Button-1>',self.getrdr)
		
		self.logbutton=Button(self.chkbuttonframe,text='LOG OFF',bg='#fff')
		self.logbutton.pack(side=TOP)
		self.logbutton.bind('<Button-1>',self.logstatusinvert)
		
		self.accumulate_status=IntVar()    #  define a control variable for the accumulate checkbutton
		self.accumulate=Checkbutton(self.chkbuttonframe,width=15,text='accumulate IDs',variable=self.accumulate_status,bg='#fff')     # checkbutton, so variable is 1 or 0
		self.accumulate.pack(side=TOP)
		
		self.class1type_status=IntVar()    #  define a control variable for the type checkbutton
		self.class1type=Checkbutton(self.chkbuttonframe,width=15,text='cl1 anti-collision',variable=self.class1type_status,bg='#fff')     # checkbutton, so variable is 1 or 0
		self.class1type.pack(side=TOP)
		
		self.stopcb_status=IntVar()    #  define a control variable for the stop checkbutton
		self.stopckbutton=Checkbutton(self.chkbuttonframe,width=15,text='STOP',variable=self.stopcb_status,bg='#fff')     # checkbutton, so variable is 1 or 0
		self.stopckbutton.pack(side=BOTTOM)	
		
		
		# -----------------------------
		
		self.scalevalue=IntVar()   # define a control variable for the power slider 
		model='NULL'

		#  default values:
		slidermin=18
		slidermax=30
		self.powerslider=Scale(self.topframe,bg='#aaa',length=300,from_=slidermin,label='reader power (dBm)',orient=HORIZONTAL, 
				relief=SUNKEN,to=slidermax,tickinterval=2,variable=self.scalevalue)    # defines the slider to set reader power
		self.powerslider.pack(side=LEFT)
		
				
		# -----------------------------
		
		
		self.antenna_select_frame=Frame(self.topframe,bg='#fff')    #  this frame contains the antenna select buttons
		self.antenna_select_frame.pack(side=LEFT,fill=Y)
				
		self.antenna_label=Label(self.antenna_select_frame, width=20,text=' ANTENNA: ')   #  label options for antenna selection
		self.antenna_label.pack(side=TOP)		
		
		self.antennaselect=IntVar()   #  define a control variable for the antenna radio buttons; this button takes the value 0,1, or 2
		self.antennaAbutton=Radiobutton(self.antenna_select_frame,padx=3, pady=3,width=12,text='A',relief=SUNKEN,variable=self.antennaselect, value=0x00)
		self.antennaAbutton.pack(side=TOP)
		
		self.antennaBbutton=Radiobutton(self.antenna_select_frame,padx=3, pady=3,width=12,text='B',relief=SUNKEN,variable=self.antennaselect, value=0x01)
		self.antennaBbutton.pack(side=TOP)
		
		self.antennaBOTHbutton=Radiobutton(self.antenna_select_frame,padx=3, pady=3, width=12,text='ALTERNATE',relief=SUNKEN,variable=self.antennaselect, value=0x02)
		self.antennaBOTHbutton.pack(side=TOP)
		
		# ----------------------------
		
		self.readerinfo=Text(self.midframe,bg='#ddd',height=1,width=125,relief=SUNKEN,borderwidth=3)     #  reader info window
		self.readerinfo.insert(1.0,'MPR info window')
		self.readerinfo.pack(side=TOP)
		
		self.cl0listlabel=Label(self.midframe,text='Class 0 Tag List')             # label for class 0 list
		self.cl0listlabel.pack(side=LEFT)
		
		self.blanklabel=Label(self.midframe,text='                                                                              ')   # spacing
		self.blanklabel.pack(side=LEFT)
		
		self.cl1listlabel=Label(self.midframe,text='Class 1 Tag List')             # label for class 1 list
		self.cl1listlabel.pack(side=RIGHT)
		
		#  ----------------------------
		
		self.class0list=Text(self.bottomframe,bg='#ddd',height=40,width=40,relief=SUNKEN,borderwidth=5)    # text widget that receives class 0 inventory
		self.class0list.pack(side=LEFT)
		self.class0list.insert(1.0,'class 0 tag list goes here')	
		
		self.class1list=Text(self.bottomframe,bg='#ddd',height=40,width=40,relief=SUNKEN,borderwidth=5)     #  text widget that receives class 1 inventory
		self.class1list.pack(side=RIGHT)
		self.class1list.insert(1.0,'class 1 tag list goes here')
		
		# -----------------------------
		
		self.dblbottomframe=Frame(self.bottomframe)
		self.dblbottomframe.pack(side=BOTTOM)
		
		self.readlabelframe=Frame(self.bottomframe,relief=SUNKEN,bg='#ccc',borderwidth=2)
		self.readlabelframe.pack(side=TOP)
		
		self.totaltagslabel=Label(self.readlabelframe,text='total tag reads',borderwidth=2)             # label for total tags read field
		self.totaltagslabel.pack(side=LEFT)
		
		self.totalreads=Text(self.readlabelframe,height=1,width=8,borderwidth=2)   # text widget that receives total reads in each inventory
		self.totalreads.pack(side=LEFT)
		
		self.uniquetagslabel=Label(self.readlabelframe,text='unique tag reads',borderwidth=2)             # label for unique tags read field
		self.uniquetagslabel.pack(side=LEFT)
		
		self.uniquereads=Text(self.readlabelframe,height=1,width=6,borderwidth=2)   # text widget that receives unique reads in accumulated inventory
		self.uniquereads.pack(side=LEFT)
		
		self.totalreadattempts=Text(self.readlabelframe,height=1,width=10,borderwidth=2)   # text widget that receives total attempts
		self.totalreadattempts.pack(side=RIGHT)
		
		self.totalreadslabel=Label(self.readlabelframe,text='total read attempts',borderwidth=2)             # label for total attempts
		self.totalreadslabel.pack(side=RIGHT)
		
		# ---------------------------
		
		self.logframe=Frame(self.bottomframe,relief=SUNKEN,bg='#ccc',borderwidth=2)		# frame for the logfile output
		self.logframe.pack(side=TOP)
		
		self.loglabelframe=Frame(self.logframe,relief=SUNKEN,bg='#ccc',borderwidth=2)                 # frame to label the logfile
		self.loglabelframe.pack(side=TOP)
		
		self.invlogon_status=IntVar()    #  define a control variable for the log checkbutton
		self.invlogon=Checkbutton(self.loglabelframe,width=5,text='ON',variable=self.invlogon_status,bg='#fff')     # checkbutton, so variable is 1 or 0
		self.invlogon.pack(side=LEFT)
		
		self.loglabel=Label(self.loglabelframe,text=' inventory log',borderwidth=2)
		self.loglabel.pack(side=LEFT)
		
		self.loglabelspace=Label(self.loglabelframe,text='                                                          ',borderwidth=2)
		self.loglabelspace.pack(side=LEFT)
		
		self.loglabel1=Label(self.loglabelframe,text=' error log',borderwidth=2)
		self.loglabel1.pack(side=RIGHT)		
		
		self.logdisplay=Text(self.logframe,height=30,width=15,relief=SUNKEN, borderwidth=2)	# text box for the logfile
		self.logdisplay.pack(side=LEFT)
		
		self.logscroll=Scrollbar(self.logframe,orient=VERTICAL,command=self.logdisplay.yview)	# scroll bar for the logfile
		self.logscroll.pack(side=LEFT, fill=Y)
		
		self.logdisplay["yscrollcommand"]=self.logscroll.set
				
		self.errordisplay=Text(self.logframe,height=30,width=50,relief=SUNKEN, borderwidth=2)	# text box for error display
		self.errordisplay.pack(side=LEFT)
		
		self.errorscroll=Scrollbar(self.logframe,orient=VERTICAL,command=self.errordisplay.yview)  # scroll bar for error display
		self.errorscroll.pack(side=RIGHT,fill=Y)
		
		self.errordisplay["yscrollcommand"]=self.errorscroll.set
		
		self.gen2on=0		#   define an instance variable for MPRGUI tracking whether a child window for Gen II has been launched

		# -----------------------------
		
		self.enigmaticlabel=Label(self.dblbottomframe,text='MPR user interface version 5.1 \n Enigmatics  www.enigmatic-consulting.com')
		self.enigmaticlabel.pack(side=BOTTOM)
		

	def PCcardport(self,event):
		'''This handler opens the serial port assuming a PC card reader and then destroys the button widgets if a valid model was received.'''
		global powermin, powermax   #  this is ugly!
		Set_serial_port('PCcard')		
		model=Start_card_get_model()
		if model==' MPR7000':
			powermin=18
			powermax=30
			slidermin=18
			slidermax=30
		else:
			powermin=15
			powermax=27
			slidermin=15
			slidermax=27
		self.powerslider.config(from_=slidermin,to=slidermax)	
		if model!='NULL':   #  we got a valid model from the card
			self.serialframe.destroy()   # remove these, we don't need 'em anymore
		#  end PCcardport
	
	def USBport(self,event):
		'''This handler opens the serial port assuming a Keyspan USB serial reader and then destroys the button widgets.'''
		global powermin, powermax   #  this is ugly!
		Set_serial_port('USB')
		model=Start_card_get_model()
		if model==' MPR7000':
			powermin=18
			powermax=30
			slidermin=18
			slidermax=30
		else:
			powermin=15
			powermax=27
			slidermin=15
			slidermax=27
		self.powerslider.config(from_=slidermin,to=slidermax)
		if model!='NULL':   # we got a valid model from the card
			self.serialframe.destroy()	 # remove these, we don't need 'em anymore
		# end USBport
		
		
	def gen2(self,event):
		'''This handler makes a window for gen 2 reads and then creates an instance of MPRGen2 within it.'''
		#  make an instance of MPRGen2 using the root window as the parent.  
		if self.gen2on==0:				# if there's already a window don't make another one!
			self.Gen2_instance1=MPRGen2(root)
			self.gen2on=1
		else:
			self.Gen2_instance1.newwindow.lift()		# raise the window up
		
	#end gen2 button handler	
	
	def getrdr(self, event):
		'''This handler calls the GetReaderInfo function, and then displays the result using the text display widget.'''
		#  get reader info
		returnlist=GetReaderInfo()
		textstring=returnlist[0]
		self.readerinfo.delete(1.0,END)    #  clear the text display widget
		self.readerinfo.insert(1.0,textstring)   #write the result in
		#  end getrdr event handler
		
	def logstatusinvert(self,event):
		'''This handler inverts the status of the TX and RX logs for now.'''
		if logstatus.TXstatus==1:
			logtrack.setTXlog(0)
			self.logbutton.config(text='LOG OFF')
		else:
			logtrack.setTXlog(1)
			self.logbutton.config(text='LOG ON')
		if logstatus.RXstatus==1:
			logtrack.setRXlog(0)
		else:
			logtrack.setRXlog(1)
		
		
	def copyclass0(self,event):
		'''This function copies all the text in the class 0 text widget to the clipboard.'''
		self.mycontainer1.clipboard_clear()
		text_to_copy=self.class0list.get(1.0,END)    #  get all the text on the class 0 list
		self.mycontainer1.clipboard_append(text_to_copy)     # append it to the clipboard
		#   end  copyclass0
		
	def copyclass1(self,event):
		'''This function copies all the text in the class 1 text widget to the clipboard.'''
		self.mycontainer1.clipboard_clear()
		text_to_copy=self.class1list.get(1.0,END)    #  get all the text on the class 0 list
		self.mycontainer1.clipboard_append(text_to_copy)     # append it to the clipboard
		#   end  copyclass1
		
		
	def class0inventory(self,event):
		'''This handler just calls the inventory_until_stop function with EPCclass=0.'''
		accumulate=self.accumulate_status.get()     #  get the status of the accumulate checkbutton
		#print 'accumulate is ', accumulate
		antenna_index=self.antennaselect.get()       # get the antenna request status
		inventory_log=self.invlogon_status.get()   # get the status of the inventory log button	
		if logtrack.RXstatus==1:
			print " "
			print "class0 inventory launched"	
		self.inventory_until_stop(0,accumulate,0,antenna_index,inventory_log)   # call the inventory function with EPCclass=0
		#  if accumulate is 0 the tag ID list is renewed on each clump, otherwise it accumulates during the inventory
		# end class0inventory  event handler
		
		
	
	def class1inventory(self,event):
		'''This handler just calls the inventory_until_stop function with EPCclass=1.'''
		accumulate=self.accumulate_status.get()     #  get the status of the accumulate checkbutton
		antenna_index=self.antennaselect.get()       # get the antenna request status
		type=self.class1type_status.get()   #  get the status of the inventory type button	 
		inventory_log=self.invlogon_status.get()   # get the status of the inventory log button
		if logtrack.RXstatus==1:
			print " "
			print "class1 inventory launched"
		self.inventory_until_stop(1,accumulate,type,antenna_index,inventory_log)   # call the inventory function with EPCclass=1
		#  if accumulate is 0 the tag ID list is renewed on each clump, otherwise it accumulates during the inventory
		# end class1inventory  event handler
		
		
	def class1tagstrength(self,event):
		'''This handler just calls tagstrength with EPCclass=1.'''
		if logtrack.RXstatus==1:
			print " "
			print "class1 tag strength launched"
		self.tagstrength(1)
		
	def class0tagstrength(self,event):
		'''This handler just calls tagstrength with EPCclass=0.'''
		if logtrack.RXstatus==1:
			print " "
			print "class0 tagstrength launched"
		self.tagstrength(0)
		
	def tagstrength(self,EPCclass=0):
		''' This handler runs 10 inventory operations at each power level until tags read goes to 0. '''
		# set maximum power
		# use variable model inherited from reader_functions
		if model==' MPR7000':
			powermax=0x1E   #  30 dBm  max power
			powermin=0x12   #  18 dBm min power
		else:
			powermax=0x1B   # 27 dBm max power
			powermin=0x0F    # 15 dBm min power
		outputstring=' '
		power=powermax
		totaltagsread=1
		tagidlist=()    # initialize the tag ID list
		
		antenna_index=self.antennaselect.get()       # get the antenna request status
		if antenna_index==0x02:
			print 'tag strength test only uses 1 antenna'
			antenna_index=0x00
		
		type=0	   # for class 1:  simple scroll, no explicit anti-collision
			
		while totaltagsread>0:    # repeat inventory until no more tags are read
			totaltagsread=0
			newidlist=()
			for y in range(0,10,1):	# run ten inventory cycles
				if EPCclass==0:
					idout=GetClass0Inventory(power,antenna_index)    # from module reader_functions
				else:
					idout=GetClass1Inventory(power,type,antenna_index)    # from module reader_functions
				#print idout
				newidlength=len(idout)
				totaltagsread=newidlength+totaltagsread  
				templist=Append_new_IDs(idout,newidlength,tagidlist)
				newidlist=templist[0]
				tagidlist=templist[1]
			# end loop to run 10 inventories
			cleaned_up_list=Clean_up_list(newidlist)
			outputstring=outputstring+cleaned_up_list[1:]
			outputstring=outputstring+'power: ' + str(power) + ' total reads: ' + str(totaltagsread)+'\n'			
			#  update power
			power=power-1
			#print 'power is ', power, 'and total reads are ', totaltagsread
			if power<powermin:
				totaltagsread=0  # can't go any farther, terminate the loop
	
			# end of the loop reading until no tags are read
		if EPCclass==1:
			self.class1list.delete(1.0,END)   #  clear the text display widget
			self.class1list.insert(1.0, outputstring[1:])
		else:
			self.class0list.delete(1.0,END)  # clear the text display widget
			self.class0list.insert(1.0, outputstring[1:])
		#  end of class1tagstrength handler
	
		
	def inventory_until_stop(self, EPCclass=0,accumulate=0,type=0,antenna_index=0x00,inventory_log=0):
		'''This function runs clumps of 10 class 0 or class 1 inventories, depending on whether the argument EPCclass=0 or 1;
		after each clump of 10, the function writes the list of unique tag ID's read to either the class 0 or class 1 text field.   
		 It also rings a bell twice if the number of tags went up vs. the previous clump, and once if the tag number went down.  Then it
		writes the total number of reads to the tags read text field.  It then updates the STOP checkbutton widget and checks to see
		if the status of the widget has become 1, in which case it resets the status and exits.  If inventory_log is 1
		the number of tags found in each inventory is written to the inventory log field. '''
		
		currstatus=0           #  this is the status of the STOP button
		oldtagsfound=0         #  this counter helps note when a new tag is found or a tag disappears by ringing the bell
		totaltagsread=0      #  this counter tracks total tags read during this inventory
		totalinv=0   # this counter tracks the number of inventories that are run
		if inventory_log==1:
			self.logdisplay.delete(1.0,END)    #  clear the log file display widget
		self.errordisplay.delete(1.0,END)  #  clear the error display widget
		if accumulate==1: tagidlist=()   # if we're accumulating tag ID's, initialize the tag ID list outside the loop
		
		while currstatus!=1:    # repeat inventory until the user presses the STOP button
			if accumulate==0:  tagidlist=()    # initialize in the loop if the tag IDs are renewed for each clump
			self.powerslider.update()   #  see if the user moved the slider
			power=self.scalevalue.get()    #   update power setting	
			#print 'power from slider is', power
			
			if antenna_index==0x02:     # prepare to alternate antennas
				antenna_index1=0x00
			else:
				antenna_index1=antenna_index
				
			for y in range(0,10,1):	# run ten inventory cycles

				if EPCclass==0:
					idout=GetClass0Inventory(power,antenna_index1)    # from module reader_functions
				elif EPCclass==1:
					idout=GetClass1Inventory(power,type,antenna_index1)    # from module reader_functions
				totalinv=totalinv+1
				if antenna_index==0x02:		# antenna alternates
					if antenna_index1==0x00:
						antenna_index1=0x01
					else:
						antenna_index1=0x00
				#print 'idout is', idout
				newidlength=len(idout)
				#  append to the log display
				if inventory_log==1:
					self.logdisplay.insert(END,newidlength)
					self.logdisplay.insert(END,'\n')
				if (newidlength>0):
					if len(idout[0])==1:  # this is an error packet
						#print "idout is", idout
						templist=idout[0]
						error_message=self.parse_error_to_log(templist[0])
						self.errordisplay.insert(END,totalinv,"   ",error_message)
						self.errordisplay.insert(END,'\n')
					else:
						totaltagsread=totaltagsread+newidlength
						templist=Append_new_IDs(idout,newidlength,tagidlist)
						tagidlist=templist[1]
					# end case of non-error packet
			# end loop to run 10 inventories
  
			tagsfound=len(tagidlist)                  # the number of unique ID's found
			if tagsfound > oldtagsfound:
				self.mycontainer1.bell()   # ring the bell twice
				delaystart=time()             # get the current time
				delaytime=0
				while delaytime<0.25:      #impose some delay 
					nowtime=time()
					delaytime=nowtime-delaystart
				self.mycontainer1.bell()
				# end case of more tags found
			if tagsfound < oldtagsfound:
				self.mycontainer1.bell()   # ring the bell once
				# end case of fewer tags found
			oldtagsfound=tagsfound
			
			if EPCclass==0:
				self.class0list.delete(1.0,END)   #  clear the text display widget
			elif EPCclass==1:
				self.class1list.delete(1.0,END)   #  clear the text display widget

			cleaned_up_list=Clean_up_list(tagidlist)
			self.totalreads.delete(1.0,END)   # clear the total-read display widget
			self.totalreads.insert(1.0,totaltagsread)
			self.uniquereads.delete(1.0,END)  # clear the unique-read display widget
			self.uniquereads.insert(1.0,tagsfound)  
			self.totalreadattempts.delete(1.0,END)   # clear the total-inventory display widget
			self.totalreadattempts.insert(1.0,totalinv)
			
			#print cleaned_up_list
			if EPCclass==0:
				self.class0list.insert(1.0, cleaned_up_list[1:])
			elif EPCclass==1:
				self.class1list.insert(1.0, cleaned_up_list[1:])

			# end of the loop over the number of inventory sets requested by the user	
			self.stopckbutton.update()   #  see if the user pressed the button
			currstatus=self.stopcb_status.get()    #   update the status	
			#print 'after inventory currstatus=', currstatus
		self.stopcb_status.set(0)   # set the button back to 'off'
		self.mycontainer1.bell()   # ring the bell three times
		delaystart=time()             # get the current time
		delaytime=0
		while delaytime<0.25:      #impose some delay 
			nowtime=time()
			delaytime=nowtime-delaystart
		self.mycontainer1.bell()
		while delaytime<0.5:      #impose some delay 
			nowtime=time()
			delaytime=nowtime-delaystart
		self.mycontainer1.bell()
		return(totaltagsread)
		
	def class1verify(self,event):
		'''This handler calls the Verify function 10 times and captures each tag response, valid or not.  It then prints them into the Class 1 tag field.
		For the moment we ignore the CRC and kill code.'''
		tagidlist=()    # initialize the list
		self.powerslider.update()   #  see if the user moved the slider
		power=self.scalevalue.get()    #   update power setting
		antenna_index=self.antennaselect.get()       # get the antenna request status
		if antenna_index==2:
			print "invalid selection"
			antenna_index=1	
		#print 'power from slider is', power
		totaltagsread=0
		if logtrack.RXstatus==1:
			print " "
			print "class1 verify launched"
		
		for y in range(0,10,1):	# run ten verify cycles
			idout=GetClass1verify(antenna_index,power)
			print idout
			newidlength=len(idout)
			totaltagsread=totaltagsread+newidlength
			for y in range(0,newidlength,1):   # construct the list of received ID strings
				tagidlist=tagidlist+(idout[y],)
			# end loop to check for new ids
		# end loop to run 10 inventories 
		tagsfound=len(tagidlist)                  # the number of ID's found
		
		self.class1list.delete(1.0,END)   #  clear the text display widget

		cleaned_up_list=' '      # accumulate the string of tag id's
		for taginfo in tagidlist:    #  clean up the format of the id strings for printing
			idstring=' '
			tagid=taginfo[0]
			#print 'tagid is', tagid
			# calculate the CRC, remembering to append two bytes of 0
			CRCinput=tagid+(0,0)
			CRCinputlength=len(CRCinput)
			CRCcalc=Class1CRC(CRCinput,CRCinputlength,0xffff)
			#print 'CRCcalc is', hex(CRCcalc)
			CRCreadlist=taginfo[1]
			CRCread=hex(CRCreadlist[0]*256+CRCreadlist[1])
			#print 'CRC read is',hex(CRCread[0]),' ',hex(CRCread[1])
			if tagid!=0:
				for z in range(0,len(tagid),1):
					nextbyte=hex(tagid[z])[2:]    # strip out the '0x' on each hex string
					if len(nextbyte)==1:
						nextbyte='0'+nextbyte    # put the leading 0 back on if needed
					idstring=idstring + ' ' + nextbyte    
	  
				cleaned_up_list=cleaned_up_list + idstring + '\n'	
				cleaned_up_list=cleaned_up_list + '  calc CRC:' + hex(CRCcalc) + '  meas CRC:' + CRCread + '\n'

		#print totaltagsread
		self.totalreads.delete(1.0,END)   # clear the total-read display widget
		self.totalreads.insert(1.0,totaltagsread)
		self.totalreadattempts.delete(1.0,END)   # clear the total-inventory display widget
		self.totalreadattempts.insert(1.0,10)    # for now just fixed at 10 tries

		self.class1list.insert(1.0, cleaned_up_list[1:])  # write the list of VERIFY results to the class 1 display widget
		#  end class1Verify


	def parse_error_to_log(self,error_code):
		'''This is the error handler.  It receives an error byte and returns the corresponding message.   Error codes from MPR API version 1.03.'''
		error_message='unknown error'
		if error_code==0xDA: 
			error_message='ping mask overflow'
		elif error_code==0xDB:
			error_message='ping mask negative shift'	
		elif error_code==0xDC:
			error_message='ping job overflow'
		elif error_code==0xDD:
			error_message='supply current out of range'
		elif error_code==0xDE:
			error_message='supply voltage out of range'
		elif error_code==0xDF:
			error_message='no valid application header'
		elif error_code==0xE0:
			error_message='error erasing class 0+ memory page'
		elif error_code==0xE1:
			error_message='error programming class 0+ memory page'
		elif error_code==0xE2:
			error_message='error setting class 0+ traversal inhibit bit'
		elif error_code==0xE3:
			error_message='error locking class 0+ memory page'
		elif error_code==0xE4:
			error_message='memory page was already locked'
		elif error_code==0xE5:
			error_message='failed to verify programmed EPC'
		elif error_code==0xE6:
			error_message='error reading class 0+ memory page'
		elif error_code==0xE7:
			error_message='no tag found for singulated command'
		elif error_code==0xF0:
			error_message='parameter out of range for command'
		elif error_code==0xF1:
			error_message='missing some data for command'
		elif error_code==0xF2:
			error_message='command not supported by reader'
		elif error_code==0xF3:
			error_message='RF power level not supported by reader'
		elif error_code==0xF4:
			error_message='PLL failed to lock'
		elif error_code==0xF5:
			error_message='antenna missing or shorted'
		elif error_code==0xF6:
			error_message='subcommand not supported by reader'
		elif error_code==0xF7:
			error_message='subcommand parameter out of range'
		elif error_code==0xF8:
			error_message='CRC for the non-volatile storage table is invalid'
		elif error_code==0xDE:
			error_message='command not supported in this mode'
		return (error_message)
				
#  end of MPRGUI class definition
#  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#  ========================================================================
#  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

class MPRGen2:
	''' This class creates the  Gen 2 graphical user interface.  The root window gets a frame, that is further subdivided into a top and bottom frame.
	The top frame contains the user interface buttons.  The bottom frame is further subdivided into a section with the MPR reader info window,
	and a section with the text fields for listing the tags read.  The button handlers depend on the update function to capture the STOP button inside 
	their repeating loop without having to leave the TK mainloop.'''
	#
	def __init__(self,parent):
		self.newwindow=Toplevel(parent)

		self.mycontainer1=Frame(self.newwindow,bg='#aca')	# this is the frame that contains the whole GUI window and all widgets
		self.mycontainer1.pack()
		
		self.topframe=Frame(self.mycontainer1,bg='#fff',relief=SUNKEN, borderwidth=5)    #  this frame contains the user interface buttons
		self.topframe.pack(side=TOP)
		
		self.bottomframe=Frame(self.mycontainer1,bg='#bbb', relief=SUNKEN, borderwidth=5)   # this frame contains the reader info window and the tag windows
		self.bottomframe.pack(side=BOTTOM)
				
		self.midframe=Frame(self.bottomframe)      #  this sub-frame contains the reader info window
		self.midframe.pack(side=TOP, fill=X)
		
		
		# ----------------------------
		#self.serialframe=Frame(self.topframe,bg='#fff')   # this temporary frame contains the serial port setting buttons  -- not used in this window for now
		#self.serialframe.pack(side=LEFT)
		
		#self.PCcardbutton=Button(self.serialframe,text='PC CARD',bg='#aaa')
		#self.PCcardbutton.pack(side=TOP)
		#self.PCcardbutton.bind('<Button-1>',self.PCcardport)

		#self.USBbutton=Button(self.serialframe,text='USB SERIAL',bg='#aaa')
		#self.USBbutton.pack(side=TOP)
		#self.USBbutton.bind('<Button-1>',self.USBport)	
		
		# - - - - - - - - - - - - - - - - - - - - - 
		self.Gen2buttonframe=Frame(self.topframe,bg='#fff')   #  this frame contains various buttons
		self.Gen2buttonframe.pack(side=LEFT,fill=Y)
		
		self.Gen2Invframe=Frame(self.Gen2buttonframe,bg='#fff')      #  this frame contains the inventory and copy buttons
		self.Gen2Invframe.pack(side=TOP,fill=Y)
		
		self.InventoryLabel=Label(self.Gen2Invframe, width=18,text='Inventory Commands')   #  label the frame
		self.InventoryLabel.pack(side=TOP)		
		
		self.Gen2InventoryButton=Button(self.Gen2Invframe,width=12,text='INVENTORY',bg='#aaa')
		self.Gen2InventoryButton.pack(side=TOP)
		self.Gen2InventoryButton.bind('<Button-1>',self.Gen2Inventory)

		#self.class0tagstrengthbutton=Button(self.Gen2Invframe,width=12,text='TAG STRENGTH',bg='#aaa')
		#self.class0tagstrengthbutton.pack(side=TOP)
		#self.class0tagstrengthbutton.bind('<Button-1>',self.class0tagstrength)			
		
		self.copyGen2Button=Button(self.Gen2Invframe,width=14,text='COPY INVENTORY',bg='#aaa')   
		self.copyGen2Button.pack(side=BOTTOM)
		self.copyGen2Button.bind('<Button-1>',self.copyGen2Inventory)
		
		self.copyGen2readsButton=Button(self.Gen2Invframe,width=14,text='COPY TAG READS',bg='#aaa')   
		self.copyGen2readsButton.pack(side=BOTTOM)
		self.copyGen2readsButton.bind('<Button-1>',self.copyGen2reads)
		
		# ----------------------------
		
		self.chkbuttonframe=Frame(self.Gen2buttonframe,bg='#fff')      #  this frame contains the accumulate and other options
		self.chkbuttonframe.pack(side=TOP,fill=Y)
		
		self.accumulate_status=IntVar()    #  define a control variable for the accumulate checkbutton
		self.accumulate=Checkbutton(self.chkbuttonframe,width=15,text='accumulate IDs',variable=self.accumulate_status,bg='#fff')     # checkbutton, so variable is 1 or 0
		self.accumulate.pack(side=TOP)
		
		self.g2stopcb_status=IntVar()    #  define a control variable for the stop checkbutton
		self.stopckbutton=Checkbutton(self.chkbuttonframe,width=15,text='STOP',variable=self.g2stopcb_status,bg='#fff')     # checkbutton, so variable is 1 or 0
		self.stopckbutton.pack(side=BOTTOM)
		
		self.mycontainer1.bind_all('<KeyPress-F12>',self.Stopinventory)	#  keyboard method for setting the STOP button
		
		
		# -----------------------------
		
		#self.Gen2WriteFrame=Frame(self.Gen2buttonframe,bg='#fff')    # this frame will have the gen 2 write buttons when I write them...
		#self.Gen2WriteFrame.pack(side=TOP)
		
		#self.Gen2WriteLabel=Label(self.Gen2WriteFrame, width=8,text=' WRITE')   #  label the frame
		#self.Gen2WriteLabel.pack(side=TOP)		
		
		# -----------------------------  frame for power and antenna select
		
		self.Gen2controlframe=Frame(self.topframe,bg='#fff')   
		self.Gen2controlframe.pack(side=LEFT,fill=Y)
		
		
		# -----------------------------  this segment defines the power slider
		
		self.scalevalueg2=IntVar()   # define a control variable for the power slider 
		#  self.scalevalueg2.set(27)    #  set default value
		#  these are default values but ideally have been reset by the serial port selection made in the main window
		slidermin=powermin   #  powermin/max are global variables in this module
		slidermax=powermax
		self.powersliderg2=Scale(self.Gen2controlframe,bg='#aaa',length=300,from_=slidermin,label='reader power (dBm)',orient=HORIZONTAL, 
				relief=SUNKEN,to=slidermax,tickinterval=2,variable=self.scalevalueg2)    # defines the slider to set reader power
		self.powersliderg2.pack(side=TOP)
		
		getslidervalue=self.scalevalueg2.get()
		#print('slider value is:', getslidervalue)
		
				
		# -----------------------------   #  this frame contains the antenna select buttons
		
		
		self.g2antenna_select_frame=Frame(self.Gen2controlframe,bg='#fff')    
		self.g2antenna_select_frame.pack(side=TOP,fill=Y)
				
		self.antenna_label=Label(self.g2antenna_select_frame, width=20,text=' ANTENNA: ')   #  label options for antenna selection
		self.antenna_label.pack(side=TOP)		
		
		self.antennaselectg2=IntVar()   #  define a control variable for the antenna radio buttons; this button takes the value 0,1, or 2
		self.antennaAbuttong2=Radiobutton(self.g2antenna_select_frame,padx=3, pady=3,width=12,text='A',relief=SUNKEN,variable=self.antennaselectg2, value=0x00)
		self.antennaAbuttong2.pack(side=TOP)
		
		self.antennaBbuttong2=Radiobutton(self.g2antenna_select_frame,padx=3, pady=3,width=12,text='B',relief=SUNKEN,variable=self.antennaselectg2, value=0x01)
		self.antennaBbuttong2.pack(side=TOP)
		
		self.antennaBOTHbuttong2=Radiobutton(self.g2antenna_select_frame,padx=3, pady=3, width=12,text='ALTERNATE',relief=SUNKEN,variable=self.antennaselectg2, value=0x02)
		self.antennaBOTHbuttong2.pack(side=TOP)
		
		# ---------------------------- #  this frame contains the session and target
		self.g2sandtframe=Frame(self.topframe,bg='#fff')
		self.g2sandtframe.pack(side=LEFT,fill=Y)
		
		
		self.g2sessionframe=Frame(self.g2sandtframe,bg='#fff')
		self.g2sessionframe.pack(side=LEFT,fill=Y)
		
		self.sessionlabel=Label(self.g2sessionframe,width=15,text='SESSION')	#  label options for inventory session
		self.sessionlabel.pack(side=TOP)
		
		self.sessionselected=IntVar()     			#  define a control variable for the session radio buttons, taking on the value 0,1,2 or 3
									#  now define all the radio buttons
		self.session0select=Radiobutton(self.g2sessionframe,padx=3,pady=3,width=6,text='0',relief=SUNKEN,variable=self.sessionselected,value=0x00)
		self.session0select.pack(side=TOP)
		
		self.session1select=Radiobutton(self.g2sessionframe,padx=3,pady=3,width=6,text='1',relief=SUNKEN,variable=self.sessionselected,value=0x01)
		self.session1select.pack(side=TOP)
		
		self.session2select=Radiobutton(self.g2sessionframe,padx=3,pady=3,width=6,text='2',relief=SUNKEN,variable=self.sessionselected,value=0x02)
		self.session2select.pack(side=TOP)
		
		self.session3select=Radiobutton(self.g2sessionframe,padx=3,pady=3,width=6,text='3',relief=SUNKEN,variable=self.sessionselected,value=0x03)
		self.session3select.pack(side=TOP)	
		
		
		self.targetselected=IntVar()				#  define a control variable for the target radio buttons, taking on the value 0 or 1 for A or B
									#  now define the radio buttons
		self.g2targetframe=Frame(self.g2sandtframe,bg='#fff')
		self.g2targetframe.pack(side=LEFT,fill=Y)
		
		self.targetlabel=Label(self.g2targetframe,width=15,text='TARGET')	#  label options for target of inventory
		self.targetlabel.pack(side=TOP)
		
		self.targetA=Radiobutton(self.g2targetframe,padx=3,pady=3,width=6,text='A',relief=SUNKEN,variable=self.targetselected,value=0x00)
		self.targetA.pack(side=TOP)
		
		self.targetB=Radiobutton(self.g2targetframe,padx=3,pady=3,width=6,text='B',relief=SUNKEN,variable=self.targetselected,value=0x01)
		self.targetB.pack(side=TOP)	
		
		self.targetALT=Radiobutton(self.g2targetframe,padx=3,pady=3,width=6,text='ALT',relief=SUNKEN,variable=self.targetselected,value=0x02)
		self.targetALT.pack(side=TOP)	
		
		self.parsliderframe=Frame(self.g2targetframe,bg='#fff')
		self.parsliderframe.pack(side=TOP,fill=Y)
		
		self.qstartvalue=IntVar()   # define a control variable for starting Q value
		self.qslider=Scale(self.parsliderframe,bg='#aaa',length=75,from_=0,label='Qst',orient=VERTICAL, 
				relief=SUNKEN,to=8,tickinterval=8,variable=self.qstartvalue)    # defines the slider to set Qstart
		self.qslider.pack(side=LEFT)
		
		self.altmaxvalue=IntVar()   # define a control variable for the number of inventories before changing target
		self.altmaxslider=Scale(self.parsliderframe,bg='#aaa',length=75,from_=1,label='Altm',orient=VERTICAL, 
				relief=SUNKEN,to=20,tickinterval=9,variable=self.altmaxvalue)    # defines the slider to set inventories before alt
		self.altmaxslider.pack(side=LEFT)
		
		
		# ----------------------------
		
		#self.readerinfo=Text(self.midframe,bg='#ddd',height=1,width=125,relief=SUNKEN,borderwidth=3)     #  reader info window
		#self.readerinfo.insert(1.0,'MPR info window')
		# self.readerinfo.pack(side=TOP)
		
		self.Gen2InventoryLabel=Label(self.midframe,text='Gen 2 inventory results')             # label for gen 2 list
		self.Gen2InventoryLabel.pack(side=LEFT)
		
		self.blanklabel=Label(self.midframe,text='EPC length / PC / EPC                                                                             ')   # spacing
		self.blanklabel.pack(side=LEFT)
		
		
		#  ----------------------------
		
		self.tagIDlengthlist=Text(self.bottomframe,bg='#ddd',height=40,width=4,relief=SUNKEN,borderwidth=2)    # text widget that receives ID length
		self.tagIDlengthlist.pack(side=LEFT)
		self.tagIDlengthlist.insert(1.0,'IDlength')	
		
		self.PCwordlist=Text(self.bottomframe,bg='#ddd',height=40,width=8,relief=SUNKEN,borderwidth=2)    # text widget that receives protocol control word
		self.PCwordlist.pack(side=LEFT)
		self.PCwordlist.insert(1.0,'PC')	
		
				
		self.tagIDlist=Text(self.bottomframe,bg='#ddd',height=40,width=40,relief=SUNKEN,borderwidth=2)    # text widget that receives tag IDs
		self.tagIDlist.pack(side=LEFT)
		self.tagIDlist.insert(1.0,'ID list')
		
		self.tagreads=Text(self.bottomframe,bg='#ddd',height=40,width=6,relief=SUNKEN,borderwidth=2)     #  text widget that receives times a tag has been read
		self.tagreads.pack(side=LEFT)
		self.tagreads.insert(1.0,'reads')
		# -----------------------------
		
		self.dblbottomframe=Frame(self.bottomframe)
		self.dblbottomframe.pack(side=BOTTOM)
		
		self.readlabelframe=Frame(self.bottomframe,relief=SUNKEN,bg='#ccc',borderwidth=2)
		self.readlabelframe.pack(side=TOP)
		
		self.totaltagslabel=Label(self.readlabelframe,text='total tag reads',borderwidth=2)             # label for total tags read field
		self.totaltagslabel.pack(side=LEFT)
		
		self.totalreads=Text(self.readlabelframe,height=1,width=8,borderwidth=2)   # text widget that receives total reads in each inventory
		self.totalreads.pack(side=LEFT)
		
		self.uniquetagslabel=Label(self.readlabelframe,text='unique tag reads',borderwidth=2)             # label for unique tags read field
		self.uniquetagslabel.pack(side=LEFT)
		
		self.uniquereads=Text(self.readlabelframe,height=1,width=6,borderwidth=2)   # text widget that receives unique reads in accumulated inventory
		self.uniquereads.pack(side=LEFT)
		
		self.totalreadattempts=Text(self.readlabelframe,height=1,width=10,borderwidth=2)   # text widget that receives total attempts
		self.totalreadattempts.pack(side=RIGHT)
		
		self.totalreadslabel=Label(self.readlabelframe,text='total read attempts',borderwidth=2)             # label for total attempts
		self.totalreadslabel.pack(side=RIGHT)
		
		# ---------------------------
		
		self.logframe=Frame(self.bottomframe,relief=SUNKEN,bg='#ccc',borderwidth=2)		# frame for the logfile and error output
		self.logframe.pack(side=TOP)
		
		self.loglabelframe=Frame(self.logframe,relief=SUNKEN,bg='#ccc',borderwidth=2)                 # frame to label the logfile
		self.loglabelframe.pack(side=TOP)
		
		self.invlogon_status=IntVar()    #  define a control variable for the log checkbutton
		self.invlogon=Checkbutton(self.loglabelframe,width=5,text='ON',variable=self.invlogon_status,bg='#fff')     # checkbutton, so variable is 1 or 0
		self.invlogon.pack(side=LEFT)
		
		self.loglabel=Label(self.loglabelframe,text=' inventory log',borderwidth=2)
		self.loglabel.pack(side=LEFT)
		
		self.loglabelspace=Label(self.loglabelframe,text='                                                          ',borderwidth=2)
		self.loglabelspace.pack(side=LEFT)
		
		self.loglabel1=Label(self.loglabelframe,text=' error log',borderwidth=2)
		self.loglabel1.pack(side=RIGHT)		
		
		self.loglogframe=Frame(self.logframe)		#  frame containing the log display text fields and a little text key
		self.loglogframe.pack(side=LEFT)
		
		self.loglogtop=Frame(self.loglogframe)
		self.loglogtop.pack(side=TOP, fill=X)
		
		self.loglogbottom=Frame(self.loglogframe)
		self.loglogbottom.pack(side=TOP)
		
		self.logdisplaykey=Label(self.loglogtop,text='tags  slots  eCRC   rCRC  coll  rounds   unique', borderwidth=1)
		self.logdisplaykey.pack(side=LEFT)
		
		self.logtagdisplay=Text(self.loglogbottom,height=30,width=4,relief=SUNKEN, borderwidth=2)	# text box for the tag numbers
		self.logtagdisplay.pack(side=LEFT)
		
		self.logslotdisplay=Text(self.loglogbottom,height=30,width=4,relief=SUNKEN, borderwidth=2)	# text box for slots
		self.logslotdisplay.pack(side=LEFT)
		
		self.logEPCerrdisplay=Text(self.loglogbottom,height=30,width=4,relief=SUNKEN, borderwidth=2)	# text box for EPC CRC errors
		self.logEPCerrdisplay.pack(side=LEFT)
		
		self.logRSPerrdisplay=Text(self.loglogbottom,height=30,width=4,relief=SUNKEN, borderwidth=2)	# text box for response CRC errors
		self.logRSPerrdisplay.pack(side=LEFT)
		
		self.logcolldisplay=Text(self.loglogbottom,height=30,width=4,relief=SUNKEN, borderwidth=2)	# text box for collisions
		self.logcolldisplay.pack(side=LEFT)
		
		self.logroundsdisplay=Text(self.loglogbottom,height=30,width=4,relief=SUNKEN, borderwidth=2)	# text box for rounds
		self.logroundsdisplay.pack(side=LEFT)
		
		self.loguniques=Text(self.loglogbottom,height=30,width=4,relief=SUNKEN,borderwidth=2)		# text box for unique reads after each inventory
		self.loguniques.pack(side=LEFT)
		
		self.scrollbuttonframe=Frame(self.loglogbottom)         #  text box for the joint scroll buttons
		self.scrollbuttonframe.pack(side=LEFT,fill=Y)
		
		self.upbutton=Button(self.scrollbuttonframe,text='up',command=self.moveup)
		self.upbutton.pack(side=TOP)
		self.downbutton=Button(self.scrollbuttonframe,text='down',command=self.movedown)
		self.downbutton.pack(side=BOTTOM)
		
		self.logscrollindex=1
				
		self.errordisplay=Text(self.logframe,height=30,width=30,relief=SUNKEN, borderwidth=2)	# text box for error display
		self.errordisplay.pack(side=LEFT)
		
		self.errorscroll=Scrollbar(self.logframe,orient=VERTICAL,command=self.errordisplay.yview)  # scroll bar for error display
		self.errorscroll.pack(side=RIGHT,fill=Y)
		
		self.errordisplay["yscrollcommand"]=self.errorscroll.set
		

		# -----------------------------
		
		self.enigmaticlabel=Label(self.dblbottomframe,text='MPR user interface version v 5.1 \n Enigmatics  www.enigmatic-consulting.com')
		self.enigmaticlabel.pack(side=BOTTOM)

		#  end MPRGen2 init
		
	#  now define event handlers
	
	#--------------------------------------
	def Gen2Inventory(self, event):
		'''Get parameters from the user, and then call Gen2Inventory_until_stop.'''
		antenna_index=self.antennaselectg2.get()       	# get the antenna request status
		logstatus=self.invlogon_status.get()			# get the log request status
		newpower=self.scalevalueg2.get()    #   update power setting
		session=self.sessionselected.get()	#  get the session request
		invtarget=self.targetselected.get()	#  get the target (A or B or alternate) of this inventory
		#print('antenna:', antenna_index,' power:', newpower)
		accumulate=self.accumulate_status.get()		#  does the user wish to accumulate ID's or renew the list on each inventory?
		Qstart=self.qstartvalue.get()		#   starting Q
		altmax=self.altmaxvalue.get()	#  how many inventories before we change the target?

		if logtrack.RXstatus==1:
			print " "
			print "gen 2 inventory launched"
		self.Gen2Inventory_until_stop(accumulate,logstatus,antenna_index,newpower,0x00,session,altmax,invtarget,Qstart)   # default values of  selected, Qstart for now
		
		
	#end Gen2Inventory
	#--------------------------------------
	
	def Stopinventory(self,event):
		'''This handler just sets the STOP control variable high so that the next inventory loop will see it and stop.'''
		self.g2stopcb_status.set(1)
	
	#--------------------------------------
	
	def Gen2Inventory_until_stop(self,accumulate=0,logstatus=0,antenna_index=0,newpower=0x1B,Select=0x00,Session=0x00,altmax=0x01,Target=0x00,Qstart=4):
		'''  This routine initializes some stuff and then loops until the user tells it to stop, taking one inventory at a shot and updating the ID list and logs.
		It constructs a list EPClist which contains tuples of (tagID length, protocol control word, tag EPC,number of reads).'''
		
		#  first initialize some loop variables
		#
		taglist=[]
		totaltagsread=0
		totaluniquetags=0
		totalattempts=0
		#print ('target is:',Target)
		if Target!=0x02:		#  this variable will be used for alternating session flag targets
			currtarget=Target
		else:
			currtarget=0x00
			altcount=0
		
		STOPvar=self.g2stopcb_status.get()	#  we ain't a gonna start until the STOP button is cleared!
		
		#  clear the log display
		self.clearLogDisplay()
		
		if antenna_index==0x02:     # prepare to alternate antennas
			antenna_index1=0x00
		else:
			antenna_index1=antenna_index
		
		while STOPvar != 1:
			#   get an inventory
			invReturn=GetGen2Inventory(antenna_index1,newpower,Select,Session,currtarget,Qstart)
			totalattempts=totalattempts+1
			#print ('called inventory with antenna:',antenna_index1,'  select=',Select,'  Session=',Session, '  target:',currtarget)    
							#  this function runs a single inventory and returns a tuple of (EPClist, inventorySummary)
							
			if antenna_index==0x02:	#  alternate antennas
				if antenna_index1==0x00:
					antenna_index1=0x01
				else:
					antenna_index1=0x00
			#print ('inside inventory loop currtarget is:', currtarget,' and target is:', Target)
			if Target==0x02:		# alternate session targets
				altcount=altcount+1
				if altcount==altmax:
					altcount=0
					if currtarget==0x00:
						currtarget=0x01
					else:
						currtarget=0x00
			
			EPClist=invReturn[0]
			invSummary=invReturn[1]
			#print('in G2Inv_until_stop, EPClist is:', EPClist)
			
			if EPClist=='ERROR':    #  we got an error packet
				error_code=invReturn[1]    #  get the error code
				error_message=Gui_instance1.parse_error_to_log(error_code)   # use the parsing routine from the Gen 1 interface to parse it
				self.errordisplay.insert(END,totalattempts,"   ",error_message)
				self.errordisplay.insert(END,'\n')
			elif EPClist!='NULL':   #  we got a valid set of packets back and expect a good inventory inside of them
				if accumulate==0:	#  in this case the taglist is just set equal to that returned by the inventory
					taglist=[]
					for i in range(0,len(EPClist),1):
						appendrecord=[EPClist[i][0],EPClist[i][1],EPClist[i][2],1]
						taglist=taglist+[appendrecord]
					# end loop over elements of EPClist
				# end case of accumulate = 0
				
				if accumulate==1:	#   in this case we need to check through the new ID's to see if we've seen them before
					taglist=self. accumulateTaglist(taglist,EPClist)
					#  this routine checks to see if each EPC ID is in taglist; if yes, increment times read, if no append
				#
				totaltagsread=totaltagsread+len(EPClist)
				totaluniquetags=len(taglist)
				#print 'for attempt number:', totalattempts,'  unique tags are:', totaluniquetags
				#
				self.totalreads.delete(1.0,END)			# fill display fields for cumulative totals	
				self.totalreads.insert(1.0,totaltagsread)
				self.uniquereads.delete(1.0,END)
				self.uniquereads.insert(1.0,totaluniquetags)
				self.totalreadattempts.delete(1.0,END)
				self.totalreadattempts.insert(1.0,totalattempts)
				#
				#  display taglist
				#  
				#print('in G2inv_until_stop, taglist is:', taglist)
				
				returnListTuple=AssignTagListToStrings(taglist)    			#  parse the tag list into strings
				
				
				IDlengthstring=returnListTuple[0]						#  the first tuple element is the ID length
				PCwordstring=returnListTuple[1]						#  the second is the protocol control word
				tagIDstring=returnListTuple[2]						#  the third is the ID itself
				nreadString=returnListTuple[3]						#  the fourth is the number of times the tag was read
			
				self.writeTaglist(IDlengthstring,PCwordstring,tagIDstring,nreadString)	# write the lists to the display fields
				
				if logstatus==1:					#  the user requested the inventory summary to be displayed
					self.logtagdisplay.insert(END,invSummary[0])
					self.logtagdisplay.insert(END,'\n')
					self.logslotdisplay.insert(END,invSummary[1]) 
					self.logslotdisplay.insert(END,'\n')  
					self.logEPCerrdisplay.insert(END,invSummary[2]) 
					self.logEPCerrdisplay.insert(END,'\n')
					self.logRSPerrdisplay.insert(END,invSummary[3])   
					self.logRSPerrdisplay.insert(END,'\n')
					self.logcolldisplay.insert(END,invSummary[4])   
					self.logcolldisplay.insert(END,'\n')
					self.logroundsdisplay.insert(END,invSummary[5])   
					self.logroundsdisplay.insert(END,'\n')
					self.loguniques.insert(END,totaluniquetags)
					self.loguniques.insert(END,'\n')
			
			#  end case of non-NULL inventory 
			
			#  see if the user is sick of this yet
			self.stopckbutton.update()			#   update it
			STOPvar=self.g2stopcb_status.get()		#   and if it is 0 we (finally) stop

		#end of case of NOT STOP
		
		self.g2stopcb_status.set(0)				#  reset the STOP button
									#  ring the bell three times
		self.mycontainer1.bell()
		delaystart=time()             # get the current time
		delaytime=0
		while delaytime<0.25:      #impose some delay 
			nowtime=time()
			delaytime=nowtime-delaystart
		self.mycontainer1.bell()
		while delaytime<0.5:      #impose some delay 
			nowtime=time()
			delaytime=nowtime-delaystart
		self.mycontainer1.bell()
		return(totaltagsread)
			
	#  Gen2InventoryUntilStop	
	
	#--------------------------------------
	
	def clearLogDisplay(self):
		'''   This is just a little subroutine to clear all the text fields in the log display.'''
		#  clear the log display
		self.logtagdisplay.delete(1.0,END) 				#   clear the tag display widget
		self.logslotdisplay.delete(1.0,END) 				#   clear the slot display widget   
		self.logEPCerrdisplay.delete(1.0,END) 			#   clear the EPC CRC error display widget  
		self.logRSPerrdisplay.delete(1.0,END) 			#   clear the response CRC error display widget   
		self.logcolldisplay.delete(1.0,END) 				#   clear the slot display widget
		self.logroundsdisplay.delete(1.0,END) 			#   clear the slot display widget
		self.loguniques.delete(1.0,END)				#   clear the unique tags display widget
	# end clearLogDisplay
	
	#--------------------------------------
	
	def moveup(self):
		'''This little subroutine moves all the log display text boxes up together.'''
		if self.logscrollindex>0:
			self.logscrollindex=self.logscrollindex-1
		self.logtagdisplay.yview(self.logscrollindex)
		self.logslotdisplay.yview(self.logscrollindex)
		self.logEPCerrdisplay.yview(self.logscrollindex)
		self.logRSPerrdisplay.yview(self.logscrollindex)
		self.logcolldisplay.yview(self.logscrollindex)
		self.logroundsdisplay.yview(self.logscrollindex)
		self.loguniques.yview(self.logscrollindex)
		
	
	#--------------------------------------
	def movedown(self):
		'''This little subroutine moves all the log display text boxes down together; need to implement a max index.'''

		self.logscrollindex=self.logscrollindex+1
		self.logtagdisplay.yview(self.logscrollindex)
		self.logslotdisplay.yview(self.logscrollindex)
		self.logEPCerrdisplay.yview(self.logscrollindex)
		self.logRSPerrdisplay.yview(self.logscrollindex)
		self.logcolldisplay.yview(self.logscrollindex)
		self.logroundsdisplay.yview(self.logscrollindex)
		self.loguniques.yview(self.logscrollindex)
	
	#--------------------------------------	
	
	def accumulateTaglist(self,taglist,EPClist):
		'''This is a little routine that searches through all the entries in EPClist and for each one checks to see 
		if the corresponding ID is already in taglist.  If yes, increment the number of reads for that tag;  if no, 
		add the new EPC to the tag list with times read=1.'''
		
		for i in range(0,len(EPClist),1):
			taginlist=0				#  start assuming this is a new tag
			checkID=EPClist[i][2]		#  get the tagID from the EPC list
			for j in range(0,len(taglist),1):    	# check through all the entries in taglist
				if checkID==taglist[j][2]:
					taginlist=1
					taglist[j][3]=taglist[j][3]+1	#  the ID was already in the list;  increment the times read
			if taginlist==0:   # we checked all the list entries but didn't find this id
				appendrecord=[EPClist[i][0],EPClist[i][1],EPClist[i][2],1]
				taglist=taglist+[appendrecord]
				# ring the bell once
				self.mycontainer1.bell()
				#delaystart=time()             # get the current time
				#delaytime=0
				#while delaytime<0.25:      #impose some delay 
				#	nowtime=time()
				#	delaytime=nowtime-delaystart
				#self.mycontainer1.bell()
		return taglist
	#  end accumulateTaglist
	
	
	#--------------------------------------
	
	def writeTaglist(self,IDlengthstring,PCwordstring,tagIDstring,nreadString):
		'''This routine simply clears all the tag display text fields and then writes the new list.'''
		
		self.tagIDlengthlist.delete(1.0,END)   					#  clear the text display widgets
		self.PCwordlist.delete(1.0,END)
		self.tagIDlist.delete(1.0,END)
		self.tagreads.delete(1.0,END)
		
		self.tagIDlengthlist.insert(1.0,IDlengthstring[1:])				# write the current lists
		self.PCwordlist.insert(1.0,PCwordstring[1:])
		self.tagIDlist.insert(1.0,tagIDstring[1:])
		self.tagreads.insert(1.0,nreadString[1:])
	
	#  end writeTaglist
	
	#--------------------------------------		
	
	def copyGen2Inventory(self,event):
		''' copy the id list to the clipboard'''
		self.mycontainer1.clipboard_clear()
		text_to_copy=self.tagIDlist.get(1.0,END)       		#  get the text in the ID list
		self.mycontainer1.clipboard_append(text_to_copy)	#  append it to the clipboard
	#end copyGen2Inventory
	
	#--------------------------------------	
	
	def copyGen2reads(self,event):
		'''copy the number of times each tag got read onto the clipboard'''
		self.mycontainer1.clipboard_clear()	
		text_to_copy=self.tagreads.get(1.0,END)			#  get the text in the tag reads column
		self.mycontainer1.clipboard_append(text_to_copy)	#  append it to the clipboard
	#  end copyGen2reads
	
	#--------------------------------------
	def getrdr(self,event):
		'''do nothing right now'''
		print("Go away, I'm sleepy.")
	#end getrdr
	
	#--------------------------------------

#  define global variables for the physical reader power settings
powermax=27
powermin=15

#   define global variable for Gen II window
gen2on=0

#  then turn on the TKinter loop to run the graphical user interface
root=Tk()
Gui_instance1=MPRGUI(root)
root.mainloop()

#   WJ Communications MPR5000/6000 Graphical User Interface for Python under Mac OS 10.3
#   version 6.0   March 25,2006
#   Daniel M. Dobkin, Enigmatics   www.enigmatic-consulting.com
#   required modules:  reader_functions, reader_functions_g2, CRCs, packet_crunch, packet_crunch_g2, pyserial, Tkinter
#  note that the first thing you need to do when the window comes up is choose the serial port type with the buttons PC Card or USB serial