def Class1CRC(inputlist,length,preload):
	'''This function finds the class 1 CRC of an input list of bytes.  The input list
	is presumed to include the appended two bytes of 00; they are NOT added here.'''
	#
	#  Pre-load the register 
	Reg=preload
	#print hex(Reg)
	Poly=0x1021   # this is the polynomial divisor
	# define some masks to keep integers from growing as they are shifted...
	bytemask=0xff
	wordmask=0xffff
	# the input list is presumed to be a list of bytes
	for x in range(0,length,1):
		inputbyte=inputlist[x]
		#print 'input byte =', hex(inputbyte)
		for y in range(0,8,1):
			#extract the msb of the input byte
			nextbit=inputbyte>>7  #shift right 7 places
			#print 'bit ',y,'=',nextbit 
			#extract carry
			carry=Reg>>15   #shift right 15 places
			#print 'carry =',carry
			#shift CRC register left 1 bit
			Reg=(Reg<<1)&wordmask   # limits us to one word in length for Reg
			if nextbit==1:
				Reg=Reg+1   #put the next bit in the LSB slot, which defaulted to 0
			if carry==1:
				Reg=Reg^Poly
			inputbyte=(inputbyte<<1)&bytemask  #shift byte; mask prevents inputbyte from growing
		#print 'register state is:', hex(Reg)
	#print
	#print 'final output:', hex(Reg)
	#print 'end of output'
	return Reg	# the final state of the register is the calculated CRC since no bitwise inversion
	#print
#   end of function  Class1CRC
#
#
def MPR_CRC(inputlist,length,preload):
	'''This function computes the CCITT CRC as shown in Held 1999 p. 317 --verified OK against Held p. 317   3/12/05 --
	and then takes the ones-complement of the result and reads it backwards -- that is, register 15 becomes LSB  -- to give
	the WJ MPR CRC, as verified against Parkinson examples from the Compact Reader College 3/12/05 '''
	# define some masks for picking off bytes or bits
	lsbmask=0x01
	bytemask=0xff
	register=[]
	#print ' '
	#print 'start of output'
	# fill registers with preload value
	for x in range(0,16,1):
		register=register+[(preload>>x)&lsbmask]
		#print 'register',x,'=',register[x]
	# now extract each byte and bit of input data and run register update
	for x in range(0,length,1):
		inputbyte=inputlist[x]
		#print 'input byte =', hex(inputbyte)
		for y in range(0,8,1):
			#extract the MSB of the input byte
			nextbit=inputbyte>>7  #shift right 7 places
			#print 'bit ',y,'=',nextbit 
			#carry is the XOR of the input bit and the previous value of register 0, the output register
			carry=(register[0]+nextbit)%2   #mod 2 addition same as XOR
			#print 'carry =', carry, '  register[0]=', register[0], '  nextbit=', nextbit
			#print 'carry =', carry
			#for the moment just shift the registers right
			for z in range(0,15,1):   # now we shift registers right -downwards- replicating XOR's w carry where needed
				if (z==3):
					register[z]=(register[z+1]+carry)%2
				elif (z==10):
					register[z]=(register[z+1]+carry)%2
				else:	
					register[z]=register[z+1]
			register[15]=carry   # and put carry into register 15, the input
			#print register
			inputbyte=(inputbyte<<1)&bytemask  #shift byte
	#complement values
	CRCvaluelsb=0
	for z in range(0,16,1):
		register[z]=(register[z]+1)%2
	#print register, ' is the 1s complement'
	for z in range(0,16,1):
		CRCvaluelsb=CRCvaluelsb+(2**(15-z))*register[z]
	#print   'lsb first value=',  hex(CRCvaluelsb)
	return CRCvaluelsb
	#print 'end of output'
	#print ' '
	#print ' '	
#   end of function  MPR_CRC
#
#
